"use client";
import styled from "styled-components";
import {Col, Container, Row} from "react-bootstrap";
import {Swiper, SwiperSlide} from 'swiper/react';
import {Autoplay, Mousewheel, Navigation, Pagination} from "swiper";
import 'swiper/css';
import 'swiper/css/navigation';
import 'swiper/css/pagination';
import 'swiper/css/scrollbar';
import SubTitle from "@/components/SubTitle";
import NewsCard from "@/components/News/NewsCard";
import React, {useState} from "react";
import reactHtmlParser from "react-html-parser";
import Button from "@/components/Button";
import Title from "@/components/Title";
import { format, parseISO } from 'date-fns';

const Strength = ({title, subtitle, text, img, data, list}) => {
    const [isBeginning, setIsBeginning] = useState(true);
    const [isEnd, setIsEnd] = useState(false);

    const handleSlideChange = (swiper) => {
        setIsBeginning(swiper.isBeginning);
        setIsEnd(swiper.isEnd);
    };

    return (
        <StyledStrength className={`news pt-120 pb-100`}>
            <Container>
                <Row>
                    <Col md={4} className={'news__left'}>
                        <Title text={data?.section_data?.subtitle} margin={'0 0 60px'}/>
                        <p>{reactHtmlParser(data?.section_data?.description)}</p>
                        <div className={'news__left__bottom'}>
                            <div className={'viewall'}>
                                <Button
                                    text={'View All News'}
                                    src={'/news-media'}
                                    background={'#001A94'}
                                    color={'#ffffff'}
                                    margin={'40px 0 0 0'}
                                />
                            </div>
                            {
                                list?.length > 2 &&
                                <div className="desk-nav">
                                    <ul>
                                        <li className={`prev ${isBeginning ? 'disabled' : ''}`}>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                 viewBox="0 0 18 18"
                                                 fill="none">
                                                <g clipPath="url(#clip0_4006_21)">
                                                    <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff"
                                                          strokeWidth="1.5"
                                                          strokeLinecap="round" strokeLinejoin="round"/>
                                                    <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff"
                                                          strokeWidth="1.5"
                                                          strokeLinecap="round" strokeLinejoin="round"/>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_4006_21">
                                                        <rect width="16.9706" height="16.9706" fill="white"
                                                              transform="translate(0.5 0.514648)"/>
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </li>
                                        <li className={`next ${isEnd ? 'disabled' : ''}`}>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                 viewBox="0 0 18 18"
                                                 fill="none">
                                                <g clipPath="url(#clip0_4006_21)">
                                                    <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff"
                                                          strokeWidth="1.5"
                                                          strokeLinecap="round" strokeLinejoin="round"/>
                                                    <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff"
                                                          strokeWidth="1.5"
                                                          strokeLinecap="round" strokeLinejoin="round"/>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_4006_21">
                                                        <rect width="16.9706" height="16.9706" fill="white"
                                                              transform="translate(0.5 0.514648)"/>
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </li>
                                    </ul>
                                </div>
                            }
                        </div>
                    </Col>
                    <Col md={{span: 7, offset: 1}} className={'news__right'}>
                        <div className={'slider'}>
                            {
                                list &&
                                <Swiper
                                    loop={false}
                                    slidesPerView={'auto'}
                                    spaceBetween={30}
                                    speed={1000}
                                    slidesPerGroup={1}
                                    modules={[Autoplay, Pagination, Navigation, Mousewheel]}
                                    navigation={{
                                        prevEl: '.prev',
                                        nextEl: '.next',
                                    }}
                                    onSlideChange={handleSlideChange}
                                    breakpoints={{
                                        320: {
                                            slidesPerView: 1,
                                            spaceBetween: 30,
                                        },
                                        768: {
                                            slidesPerView: 2,
                                            spaceBetween: 30,
                                        },
                                        1024: {
                                            slidesPerView: 2,
                                            spaceBetween: 30,
                                        },
                                    }}
                                    className="mySwiper"
                                >
                                    {
                                        list?.length > 0 &&
                                        list?.map((e, i) => {
                                            // const date = new Date(e?.data?.date);
                                            //
                                            // const options = {year: 'numeric', month: 'short', day: 'numeric'};
                                            // const formattedDate = date.toLocaleDateString('en-US', options);
                                            const formattedDate = e?.data?.date ?
                                                format(new Date(e?.data?.date), 'MMM d, yyyy') : '';
                                            return (
                                                <SwiperSlide key={i}>
                                                    <NewsCard
                                                        title={e?.data?.title}
                                                        date={formattedDate}
                                                        img={e?.images?.list?.find(f => f?.thumb === 'on')?.full_path}
                                                        link={e?.data?.slug}
                                                    />
                                                </SwiperSlide>
                                            );
                                        })
                                    }
                                </Swiper>
                            }
                        </div>
                    </Col>
                </Row>
                {
                    list?.length > 1 &&
                    <div className={'mobile-nav'}>
                        <ul>
                            <li className={`prev ${isBeginning ? 'disabled' : ''}`}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                     fill="none">
                                    <g clipPath="url(#clip0_4006_21)">
                                        <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                        <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_4006_21">
                                            <rect width="16.9706" height="16.9706" fill="white"
                                                  transform="translate(0.5 0.514648)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                            <li className={`next ${isEnd ? 'disabled' : ''}`}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                     fill="none">
                                    <g clipPath="url(#clip0_4006_21)">
                                        <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                        <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_4006_21">
                                            <rect width="16.9706" height="16.9706" fill="white"
                                                  transform="translate(0.5 0.514648)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                        </ul>
                    </div>
                }
            </Container>
        </StyledStrength>
    );
};

const StyledStrength = styled.section`
    will-change: transform;
    .news {
        &__left {
            h4 {
                color: #000;
                font-size: 32px;
                font-style: normal;
                font-weight: 700;
                line-height: 120%; /* 38.4px */
                opacity: 0.6;
                margin-bottom: 40px;
            }

            p {
                color: #000;
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
            }

            &__bottom {
                //display: flex;
                //justify-content: space-between;
            }

            .desk-nav {
                margin-top: 40px;

                ul {
                    display: flex;
                    gap: 20px;

                    li {
                        position: relative;
                        overflow: hidden;
                        height: 50px;
                        width: 50px;
                        background-color: rgba(0, 22, 124, 1);
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 50%;
                        cursor: pointer;

                        &:after {
                            content: '';
                            position: absolute;
                            height: 0;
                            width: 0;
                            left: 0;
                            right: 0;
                            top: 0;
                            bottom: 0;
                            margin: auto;
                            background-color: #001A94;
                            transition: all .5s ease;
                            border-radius: 50%;
                        }

                        SVG {
                            transition: transform 0.3s ease;
                        }

                        &:first-child {
                            svg {
                                transform: rotate(270deg);
                                transition: transform 0.3s ease;
                            }
                        }

                        &:hover {
                            &:after {
                                height: 100%;
                                width: 100%;
                            }

                            svg {
                                position: relative;
                                z-index: 99999;
                                transform: rotate(45deg);
                                transition: transform 0.3s ease;
                            }

                            &:first-child {
                                svg {
                                    transform: rotate(225deg);
                                    transition: transform 0.3s ease;
                                }
                            }
                        }

                        &.disabled {
                            background-color: rgba(0, 22, 124, 0.25);;
                            cursor: not-allowed;

                            &:hover {
                                &:after {
                                    height: 0;
                                    width: 0;
                                }
                            }
                        }
                    }
                }
            }
        }

        @media (max-width: 767px) {
            &__left {
                .desk-nav {
                    opacity: 0;
                    display: none;
                }

                margin-bottom: 40px;
            }

            &__right {
                margin-bottom: 40px;
            }
        }
    }

    .mobile-nav {
        opacity: 0 !important;
        display: none !important;

        @media (max-width: 767px) {
            opacity: 1 !important;
            display: block !important;
            ul {
                display: flex;
                gap: 20px;

                li {
                    position: relative;
                    overflow: hidden;
                    height: 50px;
                    width: 50px;
                    background-color: #001A94;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 50%;
                    cursor: pointer;

                    &:after {
                        content: '';
                        position: absolute;
                        height: 0;
                        width: 0;
                        left: 0;
                        right: 0;
                        top: 0;
                        bottom: 0;
                        margin: auto;
                        background-color: #001A94;
                        transition: all .5s ease;
                        border-radius: 50%;
                    }

                    &:first-child {
                        svg {
                            transform: rotate(270deg);
                        }
                    }

                    &:hover {
                        &:after {
                            height: 100%;
                            width: 100%;
                        }

                        svg {
                            position: relative;
                            z-index: 99999;
                        }
                    }

                    &.disabled {
                        background-color: rgba(0, 22, 124, 0.25);;
                        cursor: not-allowed;

                        &:hover {
                            &:after {
                                height: 0;
                                width: 0;
                            }
                        }
                    }
                }
            }
        }
    }


    @media (max-width: 991px) {
        .news__left {
            max-width: 100% !important;
            flex: 0 0 100%;
            margin-bottom: 40px;
        }

        .news__right {
            max-width: 100% !important;
            flex: 0 0 100% !important;
            margin-left: 0 !important;
        }
    }

`;

export default Strength;
