'use client'
import React from 'react';
import styled from "styled-components";
import {Col, Container, Row} from "react-bootstrap";
import reactHtmlParser from "react-html-parser";
import {Img} from "@/components/Img";
import ImageParallax from "@/components/ImageParallax";

const InnerBanner = ({img, text, title, data}) => {


    const handleScroll = () => {
        window.scrollBy({
            top: window.innerHeight, // Scroll by the full viewport height
            behavior: 'smooth', // Smooth scrolling
        });
    };
    return (
        <StyledInnerBanner className='InnerBanner'>
            <div className={'scroll-down'} onClick={handleScroll}>
                <svg xmlns="http://www.w3.org/2000/svg" width="102" height="103" viewBox="0 0 102 103" fill="none">
                    <g opacity="0.5">
                        <ellipse cx="51" cy="51.522" rx="50" ry="50.9707" stroke="#ffffff"/>
                        <path d="M51 31.1338V71.9104" stroke="#ffffff" strokeLinecap="round" strokeLinejoin="round"/>
                        <path d="M39 59.6775L51 71.9105L63 59.6775" stroke="#ffffff" strokeLinecap="round"
                              strokeLinejoin="round"/>
                    </g>
                </svg>
            </div>
            <ImageParallax banner={true} src={img}/>
            <Container>
                <Row>
                    <Col md={12}>
                        <div className="title">
                            <h1 className={`split-up`}>{title ? reactHtmlParser(title) : ''}</h1>
                        </div>
                    </Col>
                </Row>
            </Container>
        </StyledInnerBanner>
    );
};

const StyledInnerBanner = styled.section`
    //padding-top: calc(768 / 1366 * 100%);
    position: relative;
    height: 100vh;
    
    .scroll-down {
        cursor: pointer;
        position: absolute;
        bottom: 20px;
        left: ${props => props.offset ? props.offset + 'px' : '140px'};
        z-index: 3;

        svg {
            height: 60px;
            width: 60px;
            g {
                path {
                    animation: moveAndFade 2.5s infinite;

                    @keyframes moveAndFade {
                        0% {
                            transform: translateY(0);
                            opacity: 1;
                        }
                        50% {
                            transform: translateY(15px);
                            opacity: 0.5;
                        }
                        100% {
                            transform: translateY(30px);
                            opacity: 0;
                        }
                    }
                }
            }
        }
    }

    .container {
        position: absolute;
        height: 100%;
        top: 0;
        left: 0;
        right: 0;
        z-index: 2;
        padding: 0;
    }

    .row {
        height: 100%;
        align-items: center;
    }
    
    .title{
        display: flex;
        align-items: center;
        justify-content: center;
    }

    h1 {
        color: #FFF;
        font-size: 68px;
        font-style: normal;
        font-weight: 700;
        line-height: 120%; /* 68px */
        z-index: 2;
        text-align: center;
    }


    @media (max-width: 767px) {
        //padding-top: 0;

        .scroll-down{
            display: none;
        }
        padding-top: calc(450 / 375 * 100%);
        .container {
            bottom: 60px !important;
            top: unset !important;
            padding: 0 15px !important;
        }
        
        .row{
            //align-content: flex-end;
            gap: 30px;
        }
        
        .col-md-3{
            height: auto !important;
            .content{
                position: unset !important;
            }
        }
        
        h1{
            color: #FFF;
            font-size: 40px;
            font-style: normal;
            font-weight: 700;
            line-height: 100%; /* 40px */
        }
        
    }

    @media (max-width: 991px) {
        //padding-top: 0;

        .scroll-down{
            display: none;
        }
        padding-top: calc(450 / 375 * 100%);
        .container {
            bottom: 60px !important;
            top: unset !important;
            padding: 0 15px !important;
        }

        .row{
            align-content: flex-end;
            gap: 30px;
        }

        .col-md-3{
            height: auto !important;
            .content{
                position: unset !important;
            }
        }

        h1{
            color: #FFF;
            font-size: 40px;
            font-style: normal;
            font-weight: 700;
            line-height: 100%; /* 40px */
        }

    }
`;

export default InnerBanner;
