import {gsap} from "gsap";
import {SplitText} from "gsap/SplitText";
import {ScrollTrigger} from "gsap/ScrollTrigger";
import {useEffect} from "react";
import {usePathname} from "next/navigation";


export const TextAnimation = () => {
    const location = usePathname();
    gsap.registerPlugin(SplitText);
    gsap.registerPlugin(ScrollTrigger);


    useEffect(() => {
        if (typeof window !== 'undefined'  && window.innerWidth >= 768) {
            gsap.utils.toArray(".split-up").forEach((item) => {
                // Store original HTML content and letter spacing
                const originalHTML = item.innerHTML;
                const originalLetterSpacing = window.getComputedStyle(item).letterSpacing;

                const parentSplit = new SplitText(item, {
                    linesClass: "split-parent",
                });

                new SplitText(item, {
                    type: "lines, chars",
                    linesClass: "split-child",
                });

                gsap.from(parentSplit.lines, {
                    duration: 1,
                    yPercent: 100,
                    scrollTrigger: {
                        trigger: item,
                        start: "top 100%",
                        once: true,
                    },
                });
            });
        }
    }, [location]);

    useEffect(() => {
        if (typeof window !== 'undefined'  && window.innerWidth >= 768) {
            gsap.utils.toArray(".split-title").forEach((item) => {
                // Store original HTML content and letter spacing
                const originalHTML = item.innerHTML;
                const originalLetterSpacing = window.getComputedStyle(item).letterSpacing;

                const parentSplit = new SplitText(item, {
                    linesClass: "split-parent",
                });

                new SplitText(item, {
                    type: "lines, chars",
                    linesClass: "split-child",
                });

                gsap.from(parentSplit.lines, {
                    delay: 1.5,
                    duration: 1,
                    yPercent: 100,
                    scrollTrigger: {
                        trigger: item,
                        start: "top 100%",
                        once: true,
                    },
                });
            });
        }
    }, [location]);

}


/*---how to use

- add 'split-up' class on the tag like(h1,h2,h3,p ... etc)

*/
