import { ScrollTrigger } from "gsap/ScrollTrigger";
import { CSSPlugin, gsap } from "gsap";
import { useEffect } from "react";
import { usePathname } from "next/navigation";

export const ImageReveal = () => {
    gsap.registerPlugin(ScrollTrigger, CSSPlugin);
    const location = usePathname();
    // useEffect(() => {
    //
    //     let reveal = gsap.utils.toArray(".reveal-img");
    //     reveal.forEach((cont) => {
    //         let img = cont.querySelector("img");
    //         let tl = gsap.timeline({
    //             scrollTrigger: {
    //                 trigger: cont,
    //                 toggleActions: "restart none none reset",
    //                 once: false,
    //             },
    //         });
    //
    //         // clipPath reveal
    //         tl.from(
    //             img,
    //             1.5,
    //             {
    //                 clipPath: "inset(0% 0% 100% 0%)", // Start from bottom
    //                 ease: "power2.inOut",
    //             },
    //             {
    //                 clipPath: "inset(0% 0% 0% 0%)", // Move to top
    //                 ease: "power2.inOut",
    //             }
    //         );
    //     });
    //
    //
    // }, [location]);

    useEffect(() => {
        let reveal = gsap.utils.toArray(".reveal-img");

        reveal.forEach((cont) => {
            let img = cont.querySelector("img");

            // Check if the image is already in the viewport
            const rect = cont.getBoundingClientRect();
            const isInViewport = rect.top < window.innerHeight && rect.bottom >= 0;

            if (!isInViewport) {
                let tl = gsap.timeline({
                    scrollTrigger: {
                        trigger: cont,
                        toggleActions: "play none none reset",
                        once: true,
                        start: "top 70%",
                        end: "bottom bottom",
                        markers: false,
                        fastScrollEnd: false,
                        refreshPriority: 1,
                    },
                });

                // clipPath reveal
                tl.fromTo(
                    img,
                    { clipPath: "inset(0% 0% 100% 0%)" }, // Start from bottom
                    {
                        clipPath: "inset(0% 0% 0% 0%)", // Move to top
                        duration: 1.5,
                        ease: "power2.inOut",
                    }
                );
            } else {
                // If the image is already in the viewport, set it to fully revealed
                gsap.set(img, { clipPath: "inset(0% 0% 0% 0%)" });
            }
        });
    }, [location]);

    //content animation
    useEffect(() => {
        let allAnim = document.querySelectorAll('.fade-up');
        allAnim.forEach((el, index) => {
            gsap.fromTo(el, {
                autoAlpha: 0,
                x: 100,
                ease: "none",
            }, {
                x: 0,
                autoAlpha: 1,
                ease: "power2",
                duration: 1.5,
                scrollTrigger: {
                    id: `${index + 1}`,
                    trigger: el,
                    start: 'top center+=150',
                    toggleActions: 'play none none reverse',
                }
            })
        })
        return (() => {
            allAnim = ''
        })
    }, [location])
};