'use client';
import React from 'react';
import styled from "styled-components";
import {Container, Row, Col} from "react-bootstrap";
import Link from 'next/link'
import reactHtmlParser from "react-html-parser";

const MyComponent = ({data}) => {
    return (
        <StyledComponent className={'pt-120 pb-120 mission-vision'}>
            <Container>
                {
                    data?.posts?.list && data?.posts?.list?.length > 0 &&
                    data?.posts?.list?.map((e,i)=>{
                        return(
                            <Row key={i}>
                                <Col md={6}>
                                    <h2 className={'split-up'}>{reactHtmlParser(e?.data?.subtitle)}</h2>
                                </Col>
                                <Col md={5}>
                                    <p>
                                        {reactHtmlParser(e?.data?.description)}
                                    </p>
                                </Col>
                            </Row>
                        );
                    })
                }
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #f3f3f3;
    .row{
        border-top: 1px solid #001a95 !important;
        padding-top: 20px;
        margin-bottom: 80px;
        
        &:last-child{
            margin-bottom: 0;
        }
    }
    
    h2{
        color: #00167D;
        font-size: 60px;
        font-style: normal;
        font-weight: 700;
        line-height: 100%; /* 60px */
    }
    
    p{
        color: #29253D;
        font-size: 16px;
        font-style: normal;
        font-weight: 400;
        line-height: 24px; /* 150% */
    }
    
    
    @media(max-width: 767px){
        .col-md-6{
            margin-bottom: 30px;
            padding: 0;
        }
        .col-md-5{
            padding: 0;
        }
        .row{
            margin-bottom: 40px;
            margin-right: 0 !important;
            margin-left: 0 !important;
        }
        
        h2{
            font-size: 36px;
            font-style: normal;
            font-weight: 700;
            line-height: 100%; /* 36px */
        }
    }
`;

export default MyComponent;
