"use client";
import {useEffect, useState} from 'react';
import styled from "styled-components";
import {Container, Row, Col, Modal} from "react-bootstrap";
import {Img} from "@/components/Img";
import ImageParallax from "@/components/ImageParallax";
import reactHtmlParser from "react-html-parser";
import Title from "@/components/Title";

const Video = ({data,id, img, title, paddingTop, paddingBottom}) => {
    const [show, setShow] = useState(false);

    const handleClose = () => setShow(false);
    const handleShow = () => {
        document.documentElement.classList.add("modal-open");
        setShow(true);
    }


    return (
        <>
            <StyledComponent className={`video-modal ${paddingTop ? paddingTop : ''} ${paddingBottom ? paddingBottom : ''}`}>
                <Container>
                    <Row>
                        <Col sm={12}>
                            {
                                title &&
                                <Title text={title} margin={'0 0 40px'}/>
                            }

                            <div className="video-modal__img " onClick={handleShow}>
                                <ImageParallax src={img ? img : ''}/>
                                <div className="video-modal__img__click">
                                    <svg width="32" height="40" viewBox="0 0 32 40">
                                        <path id="Polygon_1" data-name="Polygon 1" d="M20,0,40,32H0Z"
                                              transform="translate(32) rotate(90)" fill="#fff"/>
                                    </svg>
                                    <span className="circle"/>
                                    <span className="blur"/>
                                </div>
                            </div>
                        </Col>
                    </Row>
                </Container>

            </StyledComponent>

            {/*modal*/}
            <Modal className={'modal-video'} show={show} onHide={handleClose}>
                <svg onClick={handleClose} className={'close-modal'} xmlns="http://www.w3.org/2000/svg" width="13.426"
                     height="13.423"
                     viewBox="0 0 13.426 13.423">
                    <path id="Icon_ionic-ios-close" data-name="Icon ionic-ios-close"
                          d="M19.589,18l4.8-4.8A1.124,1.124,0,0,0,22.8,11.616l-4.8,4.8-4.8-4.8A1.124,1.124,0,1,0,11.616,13.2l4.8,4.8-4.8,4.8A1.124,1.124,0,0,0,13.2,24.384l4.8-4.8,4.8,4.8A1.124,1.124,0,1,0,24.384,22.8Z"
                          transform="translate(-11.285 -11.289)" fill="#fff"/>
                </svg>


                <Modal.Body>
                    <iframe width="560" height="315"
                            src={`https://www.youtube.com/embed/${id}?si=H1t21Ym3px2yQicH;controls=0&autoplay=1&rel=0`}
                            title="YouTube video player" frameBorder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowFullScreen/>
                </Modal.Body>
            </Modal>
        </>


    );
};

const StyledComponent = styled.section`
  background-color: #F3F3F3;
  position: relative;
    overflow: hidden;
    z-index: 2;

  &:after {
    position: absolute;
    content: '';
    height: 35%;
    bottom: 0;
    width: 100%;
    background-color: #ffffff;
    //z-index: -1;
  }

    .col-sm-12{
        padding-left: 0;
        padding-right: 0;
    }
    .video-modal{
        .col-md-12{
            padding-left: 0 !important;
            padding-right: 0 !important;
        }

    }
  .video-modal__img {
    padding-top: calc(600 / 1170 * 100%);
    position: relative;
    cursor: pointer;
    z-index: 2;

    &__click {
      position: absolute;
      inset: 0;
      margin: auto;
      width: 250px;
      height: 250px;
      display: flex;
      align-items: center;
      justify-content: center;


      svg {
        position: relative;
        z-index: 2;
      }

      .circle {
        border: 1px solid #FFF;
        height: 100%;
        width: 100%;
        display: block;
        position: absolute;
        border-radius: 50%;
        transition: 1s cubic-bezier(0.4, 0, 0, 1);
      }

      .blur {
        height: 150px;
        width: 150px;
        position: absolute;
        backdrop-filter: blur(5px);
        border-radius: 50%;
        transition: .6s cubic-bezier(0.4, 0, 0, 1);
        background-color: #ffffff24;
        opacity: 0;
        transform: scale(.1);
      }
    }

    &:hover {
      .circle {
        transform: scale(.1);
      }

      .blur {
        opacity: 1;
        transform: scale(1);
      }
    }
  }

  @media (min-width: 1600px) {
    .col-sm-12 {
      //max-width: 70%;
      //width: 70%;
      //margin: auto;
    }
  }

  @media (max-width: 990px) {
    .title {
      transform: none;
    }
  }


  @media (max-width: 768px) {
      .row{
          margin: 0 !important;
      }
      .col-sm-12{
          padding-left: 15px;
          padding-right: 15px;
      }
    .video-modal__img {
      margin-left: -12px;
      margin-right: -15px;
        padding-top: calc(300 / 345 * 100%);

      &__click {
        height: 100px;
        width: 100px;
      }
    }
  }

  @media (max-width: 550px) {
    .title {
      text-align: left;
      margin-bottom: 40px;
    }
  }

`;

export default Video;
