import React, {useEffect, useRef} from 'react';
import styled from 'styled-components';
import {gsap, TimelineLite} from "gsap";
import {hover} from "@/styles/globalStyleVars";
import {usePathname} from "next/navigation";


const Message = ({offset}) => {

    let tl = new TimelineLite();
    let tl2 = new TimelineLite();
    const searchClickRef = useRef()

    const location = usePathname();
    const isDesktop = typeof window !== 'undefined' && window.innerWidth > 991;
    useEffect(() => {
        // Set initial properties
        if (isDesktop) {

            gsap.set('.reveal-up-inner-sticky', {y: '50%'});

            // Animation
            gsap.fromTo(
                '.reveal-up-inner-sticky',
                {y: '50%'},
                {
                    delay: 1.5,
                    y: '0',
                    duration: 1.5, // Adjust the duration as needed
                    ease: 'power3.out', // Experiment with different easing functions
                }
            );
        }
    }, [location])

    // on click search input toggle action --  desktop menu


    // disableScroll.on()

    return (
        <StyledMessage offset={offset} className={`sticky-message-right reveal-up-inner-sticky`}
        >
            <div className={'message_wrapperr'}>
                <div className={'social_listt'}>
                    <div>
                            <div className={'icons-wrapper-call'}>
                                <div className={'sticky-iconss'}>
                                    <a className={'sticky-icons__left'} href="https://wa.link/8pa2fp" target={'_blank'}>
                                        <svg id="Component_2_3" data-name="Component 2 – 3"
                                             xmlns="http://www.w3.org/2000/svg" width="60" height="60"
                                             viewBox="0 0 50 50">
                                            <g id="Group_13" data-name="Group 13" transform="translate(-1218 -40)">
                                                <circle id="Ellipse_6" data-name="Ellipse 6" cx="25" cy="25" r="25"
                                                        transform="translate(1218 40)" fill="#1EA965"></circle>
                                                <circle className="whatsapp-hover" id="Ellipse_8" data-name="Ellipse 8"
                                                        cx="1" cy="1" r="1" transform="translate(1242 64)"
                                                        fill="#00A651" opacity="0"></circle>
                                            </g>
                                            <path id="Icon_awesome-whatsapp" data-name="Icon awesome-whatsapp"
                                                  d="M17,5.156a9.914,9.914,0,0,0-15.6,11.96L0,22.25l5.254-1.379a9.881,9.881,0,0,0,4.737,1.205h0a10.006,10.006,0,0,0,10-9.911,9.95,9.95,0,0,0-3-7.009ZM10,20.406a8.223,8.223,0,0,1-4.2-1.147l-.3-.179L2.384,19.9l.83-3.04-.2-.312a8.253,8.253,0,1,1,15.308-4.379A8.329,8.329,0,0,1,10,20.406Zm4.518-6.17c-.246-.125-1.464-.723-1.692-.8s-.393-.125-.558.125-.638.8-.786.973-.29.188-.536.063a6.741,6.741,0,0,1-3.371-2.946c-.254-.437.254-.406.728-1.353a.459.459,0,0,0-.022-.433c-.062-.125-.558-1.344-.763-1.839s-.406-.415-.558-.424-.308-.009-.473-.009a.917.917,0,0,0-.661.308,2.783,2.783,0,0,0-.866,2.067,4.851,4.851,0,0,0,1.009,2.563A11.066,11.066,0,0,0,10.2,16.268a4.846,4.846,0,0,0,2.973.621,2.536,2.536,0,0,0,1.67-1.179,2.071,2.071,0,0,0,.143-1.179C14.924,14.42,14.759,14.357,14.513,14.237Z"
                                                  transform="translate(15 12.75)" fill="#fff"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                    </div>
                </div>

            </div>
        </StyledMessage>

    )
};


const StyledMessage = styled.div`

    &.sticky-message-right {
        position: fixed;
        right: 0;
        bottom: 30px;
        z-index: 990;
        padding: 0 50px;


        .social_listt {

            .icons-wrapper-call {
                .sticky-iconss {
                    width: fit-content;
                    //display: flex;
                    //justify-content: space-between;
                    //padding: 0 20px 0px 20px;

                    svg {
                        border-radius: 50px;
                        @keyframes blink {
                            0% {
                                r: 10;
                            }
                            50% {
                                r: 45
                            }
                            100% {
                                opacity: 0;
                            }
                        }

                        #circle {
                            stroke: rgba(115, 102, 64, 0.5);
                            animation: blink 2.5s infinite;
                        }
                    }

                    &__left {
                        cursor: pointer;
                    }
                }
            }

            @media (max-width: 767px) {
                .icons-wrapper-call {
                    .sticky-iconss {
                        flex-direction: column-reverse;
                        gap: 15px;
                        padding: 0;
                        align-items: center;
                    }
                }
            }

        }

        @media (max-width: 767px) {
            right: 10px;
            left: unset;
            bottom: 30px;
            padding: 0 15px;
        }

    }

`;


export default Message;