"use client";
import React, { useEffect, useRef, useState } from 'react';
import styled from 'styled-components';
import Modal from "react-bootstrap/Modal";
import { Col, Container, Row } from "react-bootstrap";
import SimpleBar from 'simplebar-react';
import 'simplebar-react/dist/simplebar.min.css';
import reactHtmlParser from "react-html-parser";
import Subtitle from "@/components/SubTitle";
import Img from "@/components/Img";

const PopupV1 = ({
                     show,
                     handleClose,
                     no_img,
                     item,
                     title,
                     description,
                     data,
                     subtitle,
                     img
                 }) => {
    const [open, setOpen] = useState(false);
    const [videoId, setVideo] = useState('');
    const [winWidth, setWinWidth] = useState(typeof window !== 'undefined' && window.innerWidth > 767);
    const modalRef = useRef(null);

    useEffect(() => {
        const handleResize = () => {
            setWinWidth(window.innerWidth > 767);
        };

        typeof window !== 'undefined' && window.addEventListener("resize", handleResize);
        return () => {
            typeof window !== 'undefined' && window.removeEventListener("resize", handleResize);
        };
    }, []);


    console.log('data', data)

    return (
        <StyledModal>
            <Modal
                show={show}
                onHide={handleClose}
                backdrop="static"
                keyboard={false}
                className="gph_modal popup-version-one"
            >
                <SimpleBar className="main_scroll" style={{ height: '100vh' }}>
                    <Modal.Body>
                        <Container className={'bar'}>
                            <div className={'for-close d-flex justify-content-between'}>
                                <p>{reactHtmlParser(data?.data?.subtitle)}</p>
                                <div onClick={handleClose} className="modal-close">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17.414" height="17.414" viewBox="0 0 17.414 17.414">
                                        <g id="Group_21430" data-name="Group 21430" transform="translate(-1252.722 -58.222)">
                                            <line id="Line_3989" data-name="Line 3989" y2="22.627" transform="translate(1269.429 58.929) rotate(45)" fill="none" stroke="#000" strokeLinecap="round" strokeWidth="1" />
                                            <line id="Line_3990" data-name="Line 3990" y2="22.627" transform="translate(1269.429 74.929) rotate(135)" fill="none" stroke="#000" strokeLinecap="round" strokeWidth="1" />
                                        </g>
                                    </svg>
                                </div>
                            </div>
                        </Container>
                        <Container>
                            <Row>
                                <div className="modal-data d-flex">
                                    <Col sm={7} className='modal-data__content'>
                                        <div className="scroll-div">
                                            <SimpleBar autoHide={true} style={{ maxHeight: 'calc(100vh - 100px)' }}>
                                                {data?.data?.short_desc && (
                                                    <h2>{reactHtmlParser(data?.data?.short_desc)}</h2>
                                                )}
                                                {data?.data?.description && (
                                                    <p>{reactHtmlParser(data?.data?.description)}</p>
                                                )}
                                            </SimpleBar>
                                        </div>
                                    </Col>
                                    <Col sm={5} className="modal-data__img">
                                        <div className={'image-wrapper'}>
                                            <Img src={data?.images?.[0]?.full_path}/>
                                        </div>
                                    </Col>
                                </div>
                            </Row>
                        </Container>
                    </Modal.Body>
                </SimpleBar>
            </Modal>
        </StyledModal>
    );
};

const StyledModal = styled.div`
    .modal-dialog {
        margin: 0;
    }

    h4 {
        letter-spacing: 1.5px;
    }
`;

export default PopupV1;