import React, { useEffect, useRef } from 'react';
import styled from "styled-components";
import { CSSPlugin, gsap, TimelineLite } from "gsap";
import { DrawSVGPlugin } from "gsap/dist/DrawSVGPlugin";
import { usePathname } from 'next/navigation';
import { hover } from "@/styles/globalStyleVars";

const MyComponent = () => {
    const logoRef = useRef(null);
    const pathName = usePathname();
    let tl = new TimelineLite();

    useEffect(() => {
        gsap.registerPlugin(DrawSVGPlugin);

        if (!logoRef.current) return;

        const path = logoRef.current;
        const pathLength = path.getTotalLength();

        // Set initial state
        gsap.set(path, {
            strokeDasharray: pathLength,
            strokeDashoffset: pathLength,
            opacity: 1,
            fill: 'none'
        });

        // Main timeline for page transition
        tl.fromTo('.page-change', 0.4, {
            display: 'flex',
            opacity: 1,
        }, {
            duration: 1,
            delay: 1.5,
            opacity: 0,
            display: 'none'
        });

        // Logo animation timeline
        const logoTl = gsap.timeline();
        logoTl
            .to(path, {
                strokeDashoffset: 0,
                duration: 0.9,
                ease: "power2.inOut"
            })
            .to(path, {
                fill: "#001265",
                duration: 1,
                ease: "power2.inOut"
            });

    }, [pathName]);

    return (
        <StyledComponent className={'page-change'}>
            <svg
                width="393"
                height="250"
                viewBox="0 0 393 250"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
            >
                <path
                    ref={logoRef}
                    className="logo-path"
                    fillRule="evenodd"
                    clipRule="evenodd"
                    stroke="#001265"
                    strokeWidth="2"
                    d="M355.541 187.186L360.329 180.688V180.811L376.611 217.345C380.322 225.559 374.336 234.877 365.597 234.754L132.508 231.076C128.318 230.954 124.607 228.747 122.452 225.192L50.3826 105.29V226.663H0.101562V0.713379H44.3968C48.8263 0.713379 52.7769 3.16535 54.9318 7.08851L149.748 183.018C151.783 186.941 155.733 189.393 160.043 189.393L345.844 192.09C349.675 192.09 353.266 190.374 355.541 187.186ZM293.64 47.201C293.973 47.8659 293.49 48.6491 292.746 48.6491H247.088C246.714 48.6491 246.371 48.44 246.2 48.1073L225.802 8.54638C225.458 7.88083 225.942 7.0881 226.69 7.0881H272.918C273.296 7.0881 273.642 7.30172 273.812 7.64003L293.64 47.201ZM186.106 67.8975C185.357 67.8975 184.874 68.6902 185.217 69.3558L205.615 108.917C205.787 109.249 206.13 109.458 206.504 109.458H252.161C252.905 109.458 253.389 108.675 253.055 108.01L233.227 68.4494C233.058 68.1111 232.712 67.8975 232.333 67.8975H186.106ZM174.29 170.268C168.543 170.268 163.276 166.835 160.762 161.563L98.9878 28.9112C94.3189 18.7355 101.502 6.96607 112.516 6.96607H203.141L225.169 48.527H166.388C161.839 48.527 158.966 53.431 161.121 57.4767L196.437 125.396C197.515 127.481 199.55 128.707 201.705 128.707H291.014L259.767 67.8976H292.809C298.316 67.8976 303.344 70.9626 305.978 75.9891L343.449 147.709C348.837 157.885 341.534 170.268 330.281 170.268H174.29Z"
                />
            </svg>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    height: 100vh;
    position: fixed;
    background-color: #f3f3f3;
    width: 100%;
    left: 0;
    top: 0;
    z-index: 9999999999999999999;
    display: flex;
    align-items: center;
    justify-content: center;

    svg {
        width: 180px;
        height: auto;
    }

    .logo-path {
        strokeLinecap: round;
        strokeLinejoin: round;
    }

    @media (max-width: 600px) {
        svg {
            width: 200px;
        }
    }
`;

export default MyComponent;