'use client'
import React, { useEffect, useState } from "react";
import styled from "styled-components";
import {
    Container,
    Row,
    Col,
    Accordion,
    OverlayTrigger,
    Tooltip,
} from "react-bootstrap";
import Link from "next/link";
import { CSSPlugin, gsap } from "gsap";
import CloseButton from "./CloseButton";
import 'simplebar-react/dist/simplebar.min.css';
import {usePathname, useSearchParams} from "next/navigation";
import {getMenuApi} from "@/api/api";
import reactHtmlParser from "react-html-parser";
import {lock, unlock} from "tua-body-scroll-lock";

const MyComponent = ({textColor}) => {

    gsap.registerPlugin(CSSPlugin);
    // offset
    const [offset, setOffset] = useState(0);
    useEffect(() => {
        setOffset(document.querySelector(".container")?.offsetLeft + 16);
        window.addEventListener("resize", () => {
            setOffset(document.querySelector(".container")?.offsetLeft + 16);
        });
    }, []);

    const location = usePathname();
    const slug = location.split('/')[1];

    // menu action
    useEffect(() => {
        // menu open
        let getMenu = document.querySelector(".slide-menu");
        let getClick = document.querySelector(".hamburger");
        let getCloseClick = document.querySelector(".slide-menu__close");
        const ulWrapper = document.querySelector("#project-search__right");
        let tl = gsap.timeline();
        getClick?.addEventListener("click", function (e) {
            lock();
            document.body.classList.add("menu-open");
            document.documentElement.classList.add("menu-open");
            tl.to(getMenu, {
                display: "flex",
                duration: 0,
            })
                .to(
                    ".menu-overlay",
                    {
                        display: "block",
                        duration: 0,
                    },
                    "-=.3"
                )
                .to(".menu-overlay", {
                    opacity: 1,
                })
                .to(
                    getMenu,
                    {
                        x: 0,
                        // duration: 1,
                        ease: "Power4.easeInOut",
                    },
                    "-=.5"
                )
                .to(
                    ".slide-menu li,.accordion-item ",
                    {
                        y: 0,
                        opacity: 1,
                        ease: "Power4.easeInOut",
                        stagger: 0.02,
                    },
                    "-=.3"
                );
        });

        // menu close
        window.addEventListener("click", (e) => {
            if (document.body.classList.contains("menu-open")) {
                if (
                    !e.target.matches(
                        ".hamburger,.hamburger span, .accordion-header, .accordion-header button,.accordion-header span, .accordion-header img, .accordion-collapse , .accordion-collapse div, .accordion-collapse ul, .accordion-collapse li,.slide-menu,.accordion, .accordion li"
                    )
                ) {
                    unlock();
                    tl.to(".slide-menu li,.accordion-item ", {
                        y: 20,
                        opacity: 0,
                        ease: "Power4.easeInOut",
                        stagger: 0.01,
                        duration: 0.4,
                    })
                        .to(
                            getMenu,
                            {
                                x: "100%",
                            },
                            "-=.3"
                        )
                        .to(getMenu, {
                            display: "node",
                            duration: 0,
                        })
                        .to(
                            ".menu-overlay",
                            {
                                display: "none",
                                opacity: 0,
                            },
                            "-=.3"
                        );
                    document.body.classList.remove("menu-open");
                    document.documentElement.classList.remove("menu-open");
                }
            }
        });
    }, []);

    // menu fixed on scroll
    useEffect(() => {
        if (document.body.classList.contains("scroll-down")) {
            document.body.classList.remove("scroll-down");
        }
    });

    useEffect(() => {
        const body = document.body;
        const scrollUp = "scroll-up";
        const scrollDown = "scroll-down";
        let lastScroll = 0;
        let howMuchScroll;

        if (window.screen.width < 991) {
            howMuchScroll = 150;
        } else {
            howMuchScroll = 150;
        }

        window.addEventListener("scroll", () => {
            let currentScroll = window.pageYOffset;

            if (currentScroll <= howMuchScroll) {
                body.classList.remove(scrollUp);
                body.classList.remove(scrollDown);
                return;
            }

            if (currentScroll > lastScroll && currentScroll > howMuchScroll) {
                // down
                body.classList.remove(scrollUp);
                body.classList.add(scrollDown);
            } else if (currentScroll < lastScroll && currentScroll > howMuchScroll) {
                // up
                body.classList.remove(scrollDown);
                body.classList.add(scrollUp);
            }

            lastScroll = currentScroll;
        });
    }, []);



    // menu show hide on router change
    // useEffect(() => {
    //     gsap
    //         .timeline()
    //         .to(".main-menu", {
    //             opacity: 0,
    //             duration: 0.03,
    //         })
    //         .to(".main-menu", {
    //             opacity: 1,
    //             delay: 0.8,
    //             duration: 0.5,
    //         });
    // }, [location]);


    const [getMenus, setMenus] = useState(null);

    useEffect(() => {
        const fetchSetting = async () => {
            const data = await getMenuApi();
            setMenus(data);
        };

        fetchSetting();
    }, []);

    return (
        <StyledComponent
            className={"main-menu"}
            textColor={textColor}
        >
            <div className="menu-overlay"/>
            <Container>
                <div className={'main-menu__items'}>
                    <div className="main-menu__items__left">
                        <Link prefetch={true} href={'/'}>
                            {/*<img src={'/images/static/logo_light.svg'} alt={'logo'}/>*/}
                            {/*<svg width="120" height="79" viewBox="0 0 120 79" fill="none"*/}
                            {/*     xmlns="http://www.w3.org/2000/svg">*/}
                            {/*    <g stroke="#FFFFFF" fill="none">*/}
                            {/*        <path*/}
                            {/*            d="M91.0078 37.6224C91.0299 37.4674 91.052 37.3124 91.052 37.1352C91.052 36.7808 90.9856 36.4264 90.8527 36.1385L90.8084 36.0277V36.0056L87.7741 28.7852L86.6002 25.9945L81.9048 14.8539H70.7641L75.4596 25.9945L76.0354 27.3677L76.6334 28.7631H59.9114L58.7375 25.9724L54.5293 16.0056V15.9834L54.4629 15.8506V15.8284C54.3522 15.5183 54.2857 15.1861 54.2857 14.8539C54.2857 13.7686 54.8837 12.8384 55.7918 12.3733C56.1462 12.1739 56.5449 12.0632 56.9657 12.0632H57.0543H57.1429H66.7996L64.8948 7.54491L62.0819 0.900391H41.2182C39.6678 0.900391 38.4275 2.1407 38.4275 3.69109C38.4275 4.08976 38.5161 4.44413 38.6489 4.77636L38.7375 4.9757C38.7375 4.98677 38.7431 4.99231 38.7486 4.99784C38.7542 5.00338 38.7597 5.00892 38.7597 5.01999L41.7276 12.041L42.9014 14.8317L47.5969 25.9724L48.7708 28.7631L50.9635 33.9901L52.4252 37.4452L52.7575 38.2204C53.1783 39.2171 54.175 39.9259 55.3267 39.9259H88.3499C89.701 39.8816 90.7863 38.907 91.0078 37.6224ZM80.7309 12.0631H69.5903L64.8948 0.922453H76.0354L80.7309 12.0631ZM67.9734 68.2536H67.5969L67.5526 67.8328H74.773V68.2314C74.2193 68.2536 73.8206 68.3422 73.6213 68.4529C73.4219 68.5636 73.2447 68.7408 73.134 69.0066C73.0454 69.1395 73.0233 69.4939 73.0233 70.0254V73.1041C72.0709 73.5249 71.0742 73.835 70.0554 74.0564C69.0365 74.2779 67.9734 74.3887 66.866 74.3887C65.4707 74.3887 64.2968 74.1893 63.3666 73.8128C62.4363 73.4363 61.6168 72.9269 60.9081 72.3067C60.1993 71.6866 59.6456 70.9778 59.247 70.2026C58.7154 69.1838 58.4718 68.0542 58.4718 66.8139C58.4718 64.5769 59.247 62.6943 60.8195 61.1439C62.392 59.6157 64.3854 58.8405 66.7553 58.8405C67.4862 58.8405 68.1506 58.9069 68.7486 59.0177C69.0587 59.062 69.5903 59.2392 70.299 59.505C71.0299 59.7929 71.4507 59.9258 71.5836 59.9258C71.8051 59.9258 71.9823 59.8593 72.1595 59.7043C72.3367 59.5493 72.4917 59.2835 72.6467 58.8627H73.0454V64.0897H72.6467C72.1595 62.6722 71.4286 61.5869 70.454 60.8339C69.4795 60.103 68.35 59.7264 67.2425 59.7264C66.1351 59.7264 65.2049 60.0365 64.474 60.6567C63.7209 61.2768 63.2115 62.1628 62.9014 63.2702C62.5914 64.3776 62.4363 65.5293 62.4363 66.7032C62.4363 68.1207 62.6135 69.3831 62.9457 70.4463C63.278 71.5315 63.8317 72.3067 64.5626 72.8161C65.2935 73.3256 66.2016 73.5692 67.2204 73.5692C67.5748 73.5692 67.9513 73.547 68.3278 73.4584C68.7043 73.392 69.0808 73.2813 69.4795 73.1262V70.0476C69.4795 69.4717 69.4574 69.0952 69.3688 68.918C69.3023 68.7408 69.1251 68.5858 68.8815 68.4529C68.6379 68.32 68.3278 68.2536 67.9734 68.2536ZM40.9301 60.5902C40.9301 61.0553 40.7751 61.454 40.4429 61.7862C40.1107 62.1184 39.712 62.2735 39.2469 62.2735C38.7817 62.2735 38.3831 62.1184 38.0509 61.7862C37.7186 61.454 37.5636 61.0553 37.5636 60.5902C37.5636 60.1251 37.7186 59.7264 38.0509 59.3942C38.3831 59.0841 38.7817 58.9069 39.2469 58.9069C39.712 58.9069 40.1107 59.0619 40.4429 59.3942C40.7751 59.7264 40.9301 60.1251 40.9301 60.5902ZM10.454 59.6378C11.2735 59.6157 11.8715 59.8371 12.2259 60.258C12.4917 60.568 12.6024 61.166 12.6024 62.0741V68.4529L5.27132 59.2391H0V59.6378C0.442968 59.66 0.797342 59.7264 1.04097 59.8371C1.28461 59.97 1.55039 60.2137 1.88261 60.6123L2.19269 61.011V71.4872C2.19269 72.2845 2.03765 72.8382 1.70543 73.1705C1.3732 73.5027 0.819491 73.6577 0 73.6799V74.0786H5.27132V73.6799H4.91694C4.40753 73.6799 3.96456 73.5248 3.56589 73.2369C3.16722 72.949 2.99003 72.351 2.99003 71.5093V62.0741L13.0233 74.4329H13.3998V62.0741C13.3998 61.3654 13.4662 60.8781 13.577 60.5902C13.6877 60.3023 13.8649 60.1029 14.0864 59.97C14.3079 59.8371 14.7287 59.7486 15.3488 59.66V59.2613H10.454V59.6378ZM25.8692 72.8383C25.7806 72.8383 25.692 72.8161 25.6255 72.7497C25.5591 72.6832 25.4926 72.5946 25.4705 72.4839C25.4262 72.3731 25.4262 72.0631 25.4262 71.5979V67.6334C25.4262 66.526 25.3819 65.8172 25.2711 65.5293C25.094 65.042 24.7396 64.599 24.1637 64.1782C23.5879 63.7574 22.8348 63.5581 21.8603 63.5581C21.063 63.5581 20.2878 63.691 19.5347 63.9346C18.7817 64.2004 18.2058 64.5548 17.785 65.042C17.3642 65.5293 17.1648 66.0165 17.1648 66.5481C17.1648 66.9246 17.3199 67.2347 17.6299 67.5226C17.94 67.8106 18.3166 67.9435 18.7817 67.9435C19.2025 67.9435 19.5569 67.8106 19.8226 67.5669C20.0884 67.3233 20.2213 67.0132 20.2213 66.6588C20.2213 66.3709 20.0884 66.0608 19.8005 65.7508C19.6012 65.5293 19.4904 65.3299 19.4904 65.1749C19.4904 64.9977 19.579 64.8427 19.7783 64.7098C20.0884 64.4883 20.4871 64.3997 20.9522 64.3997C21.2401 64.3997 21.5059 64.4662 21.7496 64.6212C21.9932 64.7762 22.1482 64.9534 22.2368 65.1528C22.3254 65.3521 22.3697 65.8394 22.3697 66.6146V67.6334C20.1106 68.6744 18.6488 69.4938 17.9843 70.114C17.3199 70.7342 16.9876 71.4429 16.9876 72.2181C16.9876 72.794 17.187 73.2812 17.5635 73.6577C17.94 74.0343 18.4273 74.2336 19.0253 74.2336C20.022 74.2336 21.1294 73.6799 22.3919 72.5725C22.4583 73.1262 22.6576 73.547 22.9899 73.8128C23.3221 74.0786 23.7651 74.2336 24.3631 74.2336C24.8503 74.2336 25.2933 74.1229 25.692 73.8792C26.0906 73.6356 26.4672 73.2369 26.8215 72.7054L26.4893 72.4396C26.2457 72.7054 26.0685 72.8383 25.8692 72.8383ZM22.3476 71.7751C21.8603 72.1959 21.4395 72.3953 21.0851 72.3953C20.7529 72.3953 20.5092 72.2845 20.3099 72.1074C20.0663 71.8637 19.9555 71.5536 19.9555 71.2214C19.9555 70.8227 20.0884 70.4241 20.3764 70.0254C20.7972 69.4274 21.4616 68.8737 22.3476 68.3643V71.7751ZM30.5428 65.9502C30.7864 66.2382 31.4287 66.7476 32.514 67.4785C33.5993 68.2094 34.308 68.8074 34.6181 69.3168C34.9503 69.8262 35.1275 70.4021 35.1275 71.0222C35.1275 71.5981 34.9946 72.1518 34.7067 72.7055C34.4188 73.2592 34.0201 73.68 33.5107 73.9679C32.9791 74.2559 32.4033 74.4109 31.7831 74.4109C31.2737 74.4109 30.6314 74.2559 29.8119 73.9458L29.729 73.9208L29.729 73.9208C29.5562 73.8685 29.4459 73.8351 29.3689 73.8351C29.1253 73.8351 28.926 74.0344 28.7709 74.3888H28.4166L28.2394 70.7121H28.6159C28.9481 71.6867 29.3911 72.3954 29.967 72.8827C30.5207 73.3699 31.0744 73.6136 31.5838 73.6136C31.9382 73.6136 32.2261 73.5028 32.4476 73.2813C32.6691 73.082 32.7798 72.8162 32.7798 72.5062C32.7798 72.1518 32.6691 71.8417 32.4476 71.5981C32.2261 71.3544 31.7388 70.9558 30.9858 70.4464C29.8784 69.6712 29.1475 69.0732 28.8152 68.6745C28.328 68.0543 28.0843 67.412 28.0843 66.6811C28.0843 65.8838 28.3723 65.175 28.9038 64.5327C29.4354 63.8904 30.2327 63.5803 31.2516 63.5803C31.8053 63.5803 32.359 63.7132 32.8684 63.979C33.0677 64.0898 33.2228 64.1341 33.3557 64.1341C33.4885 64.1341 33.5771 64.0898 33.6657 64.0455C33.7322 64.0012 33.8651 63.824 34.0423 63.5803H34.4188L34.5738 67.0798H34.1973C33.7543 66.0388 33.3114 65.3301 32.8241 64.9536C32.359 64.577 31.8717 64.3777 31.4066 64.3777C31.0965 64.3777 30.8307 64.4884 30.6314 64.6878C30.4321 64.8871 30.3213 65.1086 30.3213 65.3744C30.3213 65.5737 30.3878 65.773 30.5428 65.9502ZM40.7751 71.9745V63.8682H36.4783V64.2669C36.9656 64.2891 37.2757 64.3998 37.4529 64.6213C37.63 64.8206 37.6965 65.2857 37.6965 65.9945V71.9745C37.6965 72.7054 37.63 73.1484 37.475 73.3034C37.2535 73.5471 36.9213 73.68 36.4562 73.7021V74.1008H41.9933V73.7021C41.506 73.68 41.1738 73.5692 41.0187 73.3477C40.8416 73.1484 40.7751 72.6833 40.7751 71.9745ZM50.5868 63.5581C50.1217 63.5581 49.6123 63.7353 49.1029 64.0896C48.5935 64.444 47.9955 65.1306 47.3089 66.1937V63.8682H43.1228V64.2668C43.4772 64.3111 43.7208 64.3776 43.8537 64.4662C43.9866 64.5547 44.0974 64.7098 44.1638 64.9091C44.2303 65.0642 44.2524 65.4407 44.2524 66.0165V71.6865C44.2524 72.5725 44.1638 73.1262 44.0088 73.3255C43.8537 73.5248 43.5437 73.6577 43.1007 73.6799V74.0786H48.6378V73.6799C48.2391 73.6577 47.9512 73.5913 47.774 73.5027C47.5968 73.4141 47.4639 73.2591 47.3753 73.0597C47.331 72.949 47.2867 72.6832 47.2867 72.2624L47.2646 71.6422V69.2945C47.2646 68.4307 47.3753 67.6555 47.619 66.9468C47.774 66.4817 47.9955 66.1273 48.3056 65.8837C48.5049 65.7286 48.7042 65.64 48.9036 65.64C48.9922 65.64 49.0808 65.6622 49.1472 65.7065C49.1818 65.7238 49.2974 65.8221 49.4836 65.9804L49.5938 66.0741L49.6566 66.1273C49.9445 66.3709 50.2768 66.5038 50.6754 66.5038C51.0077 66.5038 51.2956 66.3709 51.5392 66.1051C51.7829 65.8394 51.8936 65.4628 51.8936 64.9756C51.8936 64.5105 51.7607 64.1561 51.5392 63.9124C51.3177 63.6688 50.9855 63.5581 50.5868 63.5581ZM83.3885 63.5581C82.9234 63.5581 82.414 63.7353 81.9046 64.0896C81.3952 64.444 80.7972 65.1306 80.1106 66.1937V63.8682H75.9245V64.2668C76.2789 64.3111 76.5225 64.3776 76.6554 64.4662C76.7883 64.5547 76.899 64.7098 76.9655 64.9091C77.0319 65.0642 77.0541 65.4407 77.0541 66.0165V71.6865C77.0541 72.5725 76.9655 73.1262 76.8105 73.3255C76.6554 73.5248 76.3453 73.6577 75.9024 73.6799V74.0786H81.4395V73.6799C81.0408 73.6577 80.7529 73.5913 80.5757 73.5027C80.3985 73.4141 80.2656 73.2591 80.177 73.0597C80.1327 72.949 80.0884 72.6832 80.0884 72.2624V71.6422V69.2945C80.0884 68.4307 80.1992 67.6555 80.4428 66.9468C80.5978 66.4817 80.8193 66.1273 81.1294 65.8837C81.3287 65.7286 81.5281 65.64 81.7274 65.64C81.816 65.64 81.9046 65.6622 81.971 65.7065C82.0056 65.7237 82.1209 65.8218 82.3065 65.9797L82.3068 65.9799L82.3073 65.9803L82.3941 66.0541L82.4804 66.1273C82.7684 66.3709 83.1006 66.5038 83.4771 66.5038C83.8093 66.5038 84.0973 66.3709 84.3409 66.1051C84.5845 65.8394 84.6953 65.4628 84.6953 64.9756C84.6953 64.5105 84.5845 64.1561 84.3409 63.9124C84.1194 63.6688 83.7872 63.5581 83.3885 63.5581ZM90.321 63.5581C91.2069 63.5581 92.0264 63.7796 92.8016 64.2447C93.5546 64.6876 94.1526 65.3521 94.5513 66.1937C94.95 67.0575 95.1493 67.9877 95.1493 68.9844C95.1493 70.4462 94.7728 71.6644 94.0419 72.6389C93.1338 73.8128 91.8935 74.4108 90.3431 74.4108C88.7927 74.4108 87.6189 73.8792 86.7772 72.794C85.9577 71.7087 85.5369 70.4905 85.5369 69.0287C85.5369 67.5669 85.9799 66.2823 86.8215 65.1971C87.6632 64.1118 88.837 63.5581 90.321 63.5581ZM91.1183 73.3698C91.4062 73.1262 91.6056 72.7718 91.6942 72.3288C91.8492 71.6422 91.9157 70.2247 91.9378 68.1206C91.9378 66.8803 91.8714 66.0387 91.7385 65.5736C91.5834 65.1085 91.3841 64.7762 91.1183 64.5547C90.919 64.3997 90.6754 64.3333 90.3653 64.3333C89.9888 64.3333 89.6787 64.4662 89.4129 64.7541C89.1471 65.042 88.9699 65.5957 88.8813 66.4152C88.7927 67.2347 88.7484 68.3864 88.7484 69.8704C88.7484 70.6456 88.7927 71.3765 88.9035 72.0631C88.9699 72.5725 89.1471 72.9711 89.4129 73.2369C89.6565 73.5027 89.9666 73.6356 90.2988 73.6356C90.6311 73.6356 90.8968 73.547 91.1183 73.3698ZM106.645 71.8638V63.846H102.481V64.2447C102.924 64.3112 103.234 64.4219 103.367 64.6212C103.499 64.8206 103.588 65.2857 103.588 66.0609V71.5315C103.167 72.1074 102.835 72.4839 102.525 72.6833C102.303 72.8161 102.082 72.8826 101.816 72.8826C101.617 72.8826 101.44 72.8383 101.285 72.7276C101.13 72.6168 101.019 72.4618 100.952 72.2403C100.886 72.0188 100.842 71.5537 100.842 70.8228V63.8239H96.6777V64.2226C97.1207 64.289 97.4308 64.3998 97.5637 64.5991C97.6966 64.7984 97.7852 65.2635 97.7852 66.0387V70.0919C97.7852 71.2658 97.8738 72.1074 98.0066 72.5725C98.1395 73.0376 98.4496 73.4585 98.9147 73.8128C99.3577 74.1672 99.8893 74.3444 100.465 74.3444C101.063 74.3444 101.617 74.2115 102.104 73.9457C102.591 73.6799 103.079 73.2591 103.566 72.6611V74.0343H107.73V73.6356C107.287 73.5913 106.977 73.4585 106.844 73.2813C106.711 73.1041 106.667 72.639 106.645 71.8638ZM116.102 63.5581C116.855 63.5581 117.542 63.8017 118.162 64.2668C118.76 64.7319 119.247 65.3742 119.513 66.2159C119.845 67.0575 120 67.9435 120 68.918C120 69.959 119.845 70.8892 119.513 71.753C119.181 72.6168 118.693 73.2812 118.073 73.7242C117.453 74.1672 116.744 74.3886 115.969 74.3886C115.415 74.3886 114.884 74.2558 114.396 74.0121C114.02 73.8128 113.643 73.5027 113.245 73.0376V76.8471C113.245 77.3565 113.289 77.7109 113.378 77.9102C113.466 78.1096 113.599 78.2425 113.776 78.3311C113.953 78.4196 114.308 78.4639 114.817 78.4639V78.8626H108.97V78.4639C109.413 78.4639 109.745 78.3311 109.967 78.0874C110.122 77.9102 110.188 77.4894 110.188 76.7807V65.9723C110.188 65.2635 110.122 64.7984 109.945 64.599C109.767 64.3776 109.457 64.2668 108.97 64.2447V63.846H113.245V65.1971C113.621 64.6876 113.976 64.289 114.352 64.0675C114.884 63.7353 115.482 63.5581 116.102 63.5581ZM115.282 73.2812C115.681 73.2812 115.991 73.0819 116.257 72.6611C116.633 72.0409 116.811 70.9335 116.811 69.1616C116.811 67.3897 116.611 66.1716 116.19 65.5293C115.925 65.1085 115.548 64.887 115.083 64.887C114.352 64.887 113.732 65.4185 113.267 66.4817V71.9523C113.887 72.8383 114.574 73.2812 115.282 73.2812ZM72.6688 25.9945H61.5282L57.9401 17.4895L56.8327 14.8539H67.9955L72.6688 25.9945ZM93.6435 42.6943L96.7 49.959C96.8329 50.3134 96.8993 50.6677 96.9215 51.0664C96.9215 52.6168 95.659 53.8571 94.1308 53.8571H48.195H47.2426C46.1573 53.8571 45.2271 53.237 44.762 52.3289C44.762 52.3178 44.7565 52.3123 44.7509 52.3067C44.7454 52.3012 44.7398 52.2957 44.7398 52.2846L44.6291 52.0188C44.6164 52.0061 44.611 52.0006 44.6087 51.9941C44.607 51.9893 44.607 51.9839 44.607 51.9745L40.7088 42.6943L39.535 39.9036L37.0544 33.99L34.8617 28.763L34.2637 27.3676V53.835H23.123V0.922453H34.2637L37.0986 7.54482L39.0034 12.0631L40.1773 14.8538L44.8727 25.9944L46.0466 28.7851L48.2393 34.0122L50.7199 39.9258L51.0078 40.6124L51.1407 40.9446C51.1518 40.9667 51.1629 40.9944 51.174 41.0221C51.185 41.0498 51.1961 41.0775 51.2072 41.0996L51.8716 42.6943H53.6214H53.7099H53.7985H89.3689H89.4575H89.546C91.03 42.65 92.226 41.4097 92.226 39.9036C92.226 39.5313 92.161 39.1806 92.0311 38.873L92.4696 39.9036L93.6435 42.6943Z"*/}
                            {/*        />*/}
                            {/*    </g>*/}

                            {/*    <g stroke-opacity="0" stroke="#00167D" fill="#FFFFFF">*/}
                            {/*        <path*/}
                            {/*            d="M91.0078 37.6224C91.0299 37.4674 91.052 37.3124 91.052 37.1352C91.052 36.7808 90.9856 36.4264 90.8527 36.1385L90.8084 36.0277V36.0056L87.7741 28.7852L86.6002 25.9945L81.9048 14.8539H70.7641L75.4596 25.9945L76.0354 27.3677L76.6334 28.7631H59.9114L58.7375 25.9724L54.5293 16.0056V15.9834L54.4629 15.8506V15.8284C54.3522 15.5183 54.2857 15.1861 54.2857 14.8539C54.2857 13.7686 54.8837 12.8384 55.7918 12.3733C56.1462 12.1739 56.5449 12.0632 56.9657 12.0632H57.0543H57.1429H66.7996L64.8948 7.54491L62.0819 0.900391H41.2182C39.6678 0.900391 38.4275 2.1407 38.4275 3.69109C38.4275 4.08976 38.5161 4.44413 38.6489 4.77636L38.7375 4.9757C38.7375 4.98677 38.7431 4.99231 38.7486 4.99784C38.7542 5.00338 38.7597 5.00892 38.7597 5.01999L41.7276 12.041L42.9014 14.8317L47.5969 25.9724L48.7708 28.7631L50.9635 33.9901L52.4252 37.4452L52.7575 38.2204C53.1783 39.2171 54.175 39.9259 55.3267 39.9259H88.3499C89.701 39.8816 90.7863 38.907 91.0078 37.6224ZM80.7309 12.0631H69.5903L64.8948 0.922453H76.0354L80.7309 12.0631ZM67.9734 68.2536H67.5969L67.5526 67.8328H74.773V68.2314C74.2193 68.2536 73.8206 68.3422 73.6213 68.4529C73.4219 68.5636 73.2447 68.7408 73.134 69.0066C73.0454 69.1395 73.0233 69.4939 73.0233 70.0254V73.1041C72.0709 73.5249 71.0742 73.835 70.0554 74.0564C69.0365 74.2779 67.9734 74.3887 66.866 74.3887C65.4707 74.3887 64.2968 74.1893 63.3666 73.8128C62.4363 73.4363 61.6168 72.9269 60.9081 72.3067C60.1993 71.6866 59.6456 70.9778 59.247 70.2026C58.7154 69.1838 58.4718 68.0542 58.4718 66.8139C58.4718 64.5769 59.247 62.6943 60.8195 61.1439C62.392 59.6157 64.3854 58.8405 66.7553 58.8405C67.4862 58.8405 68.1506 58.9069 68.7486 59.0177C69.0587 59.062 69.5903 59.2392 70.299 59.505C71.0299 59.7929 71.4507 59.9258 71.5836 59.9258C71.8051 59.9258 71.9823 59.8593 72.1595 59.7043C72.3367 59.5493 72.4917 59.2835 72.6467 58.8627H73.0454V64.0897H72.6467C72.1595 62.6722 71.4286 61.5869 70.454 60.8339C69.4795 60.103 68.35 59.7264 67.2425 59.7264C66.1351 59.7264 65.2049 60.0365 64.474 60.6567C63.7209 61.2768 63.2115 62.1628 62.9014 63.2702C62.5914 64.3776 62.4363 65.5293 62.4363 66.7032C62.4363 68.1207 62.6135 69.3831 62.9457 70.4463C63.278 71.5315 63.8317 72.3067 64.5626 72.8161C65.2935 73.3256 66.2016 73.5692 67.2204 73.5692C67.5748 73.5692 67.9513 73.547 68.3278 73.4584C68.7043 73.392 69.0808 73.2813 69.4795 73.1262V70.0476C69.4795 69.4717 69.4574 69.0952 69.3688 68.918C69.3023 68.7408 69.1251 68.5858 68.8815 68.4529C68.6379 68.32 68.3278 68.2536 67.9734 68.2536ZM40.9301 60.5902C40.9301 61.0553 40.7751 61.454 40.4429 61.7862C40.1107 62.1184 39.712 62.2735 39.2469 62.2735C38.7817 62.2735 38.3831 62.1184 38.0509 61.7862C37.7186 61.454 37.5636 61.0553 37.5636 60.5902C37.5636 60.1251 37.7186 59.7264 38.0509 59.3942C38.3831 59.0841 38.7817 58.9069 39.2469 58.9069C39.712 58.9069 40.1107 59.0619 40.4429 59.3942C40.7751 59.7264 40.9301 60.1251 40.9301 60.5902ZM10.454 59.6378C11.2735 59.6157 11.8715 59.8371 12.2259 60.258C12.4917 60.568 12.6024 61.166 12.6024 62.0741V68.4529L5.27132 59.2391H0V59.6378C0.442968 59.66 0.797342 59.7264 1.04097 59.8371C1.28461 59.97 1.55039 60.2137 1.88261 60.6123L2.19269 61.011V71.4872C2.19269 72.2845 2.03765 72.8382 1.70543 73.1705C1.3732 73.5027 0.819491 73.6577 0 73.6799V74.0786H5.27132V73.6799H4.91694C4.40753 73.6799 3.96456 73.5248 3.56589 73.2369C3.16722 72.949 2.99003 72.351 2.99003 71.5093V62.0741L13.0233 74.4329H13.3998V62.0741C13.3998 61.3654 13.4662 60.8781 13.577 60.5902C13.6877 60.3023 13.8649 60.1029 14.0864 59.97C14.3079 59.8371 14.7287 59.7486 15.3488 59.66V59.2613H10.454V59.6378ZM25.8692 72.8383C25.7806 72.8383 25.692 72.8161 25.6255 72.7497C25.5591 72.6832 25.4926 72.5946 25.4705 72.4839C25.4262 72.3731 25.4262 72.0631 25.4262 71.5979V67.6334C25.4262 66.526 25.3819 65.8172 25.2711 65.5293C25.094 65.042 24.7396 64.599 24.1637 64.1782C23.5879 63.7574 22.8348 63.5581 21.8603 63.5581C21.063 63.5581 20.2878 63.691 19.5347 63.9346C18.7817 64.2004 18.2058 64.5548 17.785 65.042C17.3642 65.5293 17.1648 66.0165 17.1648 66.5481C17.1648 66.9246 17.3199 67.2347 17.6299 67.5226C17.94 67.8106 18.3166 67.9435 18.7817 67.9435C19.2025 67.9435 19.5569 67.8106 19.8226 67.5669C20.0884 67.3233 20.2213 67.0132 20.2213 66.6588C20.2213 66.3709 20.0884 66.0608 19.8005 65.7508C19.6012 65.5293 19.4904 65.3299 19.4904 65.1749C19.4904 64.9977 19.579 64.8427 19.7783 64.7098C20.0884 64.4883 20.4871 64.3997 20.9522 64.3997C21.2401 64.3997 21.5059 64.4662 21.7496 64.6212C21.9932 64.7762 22.1482 64.9534 22.2368 65.1528C22.3254 65.3521 22.3697 65.8394 22.3697 66.6146V67.6334C20.1106 68.6744 18.6488 69.4938 17.9843 70.114C17.3199 70.7342 16.9876 71.4429 16.9876 72.2181C16.9876 72.794 17.187 73.2812 17.5635 73.6577C17.94 74.0343 18.4273 74.2336 19.0253 74.2336C20.022 74.2336 21.1294 73.6799 22.3919 72.5725C22.4583 73.1262 22.6576 73.547 22.9899 73.8128C23.3221 74.0786 23.7651 74.2336 24.3631 74.2336C24.8503 74.2336 25.2933 74.1229 25.692 73.8792C26.0906 73.6356 26.4672 73.2369 26.8215 72.7054L26.4893 72.4396C26.2457 72.7054 26.0685 72.8383 25.8692 72.8383ZM22.3476 71.7751C21.8603 72.1959 21.4395 72.3953 21.0851 72.3953C20.7529 72.3953 20.5092 72.2845 20.3099 72.1074C20.0663 71.8637 19.9555 71.5536 19.9555 71.2214C19.9555 70.8227 20.0884 70.4241 20.3764 70.0254C20.7972 69.4274 21.4616 68.8737 22.3476 68.3643V71.7751ZM30.5428 65.9502C30.7864 66.2382 31.4287 66.7476 32.514 67.4785C33.5993 68.2094 34.308 68.8074 34.6181 69.3168C34.9503 69.8262 35.1275 70.4021 35.1275 71.0222C35.1275 71.5981 34.9946 72.1518 34.7067 72.7055C34.4188 73.2592 34.0201 73.68 33.5107 73.9679C32.9791 74.2559 32.4033 74.4109 31.7831 74.4109C31.2737 74.4109 30.6314 74.2559 29.8119 73.9458L29.729 73.9208L29.729 73.9208C29.5562 73.8685 29.4459 73.8351 29.3689 73.8351C29.1253 73.8351 28.926 74.0344 28.7709 74.3888H28.4166L28.2394 70.7121H28.6159C28.9481 71.6867 29.3911 72.3954 29.967 72.8827C30.5207 73.3699 31.0744 73.6136 31.5838 73.6136C31.9382 73.6136 32.2261 73.5028 32.4476 73.2813C32.6691 73.082 32.7798 72.8162 32.7798 72.5062C32.7798 72.1518 32.6691 71.8417 32.4476 71.5981C32.2261 71.3544 31.7388 70.9558 30.9858 70.4464C29.8784 69.6712 29.1475 69.0732 28.8152 68.6745C28.328 68.0543 28.0843 67.412 28.0843 66.6811C28.0843 65.8838 28.3723 65.175 28.9038 64.5327C29.4354 63.8904 30.2327 63.5803 31.2516 63.5803C31.8053 63.5803 32.359 63.7132 32.8684 63.979C33.0677 64.0898 33.2228 64.1341 33.3557 64.1341C33.4885 64.1341 33.5771 64.0898 33.6657 64.0455C33.7322 64.0012 33.8651 63.824 34.0423 63.5803H34.4188L34.5738 67.0798H34.1973C33.7543 66.0388 33.3114 65.3301 32.8241 64.9536C32.359 64.577 31.8717 64.3777 31.4066 64.3777C31.0965 64.3777 30.8307 64.4884 30.6314 64.6878C30.4321 64.8871 30.3213 65.1086 30.3213 65.3744C30.3213 65.5737 30.3878 65.773 30.5428 65.9502ZM40.7751 71.9745V63.8682H36.4783V64.2669C36.9656 64.2891 37.2757 64.3998 37.4529 64.6213C37.63 64.8206 37.6965 65.2857 37.6965 65.9945V71.9745C37.6965 72.7054 37.63 73.1484 37.475 73.3034C37.2535 73.5471 36.9213 73.68 36.4562 73.7021V74.1008H41.9933V73.7021C41.506 73.68 41.1738 73.5692 41.0187 73.3477C40.8416 73.1484 40.7751 72.6833 40.7751 71.9745ZM50.5868 63.5581C50.1217 63.5581 49.6123 63.7353 49.1029 64.0896C48.5935 64.444 47.9955 65.1306 47.3089 66.1937V63.8682H43.1228V64.2668C43.4772 64.3111 43.7208 64.3776 43.8537 64.4662C43.9866 64.5547 44.0974 64.7098 44.1638 64.9091C44.2303 65.0642 44.2524 65.4407 44.2524 66.0165V71.6865C44.2524 72.5725 44.1638 73.1262 44.0088 73.3255C43.8537 73.5248 43.5437 73.6577 43.1007 73.6799V74.0786H48.6378V73.6799C48.2391 73.6577 47.9512 73.5913 47.774 73.5027C47.5968 73.4141 47.4639 73.2591 47.3753 73.0597C47.331 72.949 47.2867 72.6832 47.2867 72.2624L47.2646 71.6422V69.2945C47.2646 68.4307 47.3753 67.6555 47.619 66.9468C47.774 66.4817 47.9955 66.1273 48.3056 65.8837C48.5049 65.7286 48.7042 65.64 48.9036 65.64C48.9922 65.64 49.0808 65.6622 49.1472 65.7065C49.1818 65.7238 49.2974 65.8221 49.4836 65.9804L49.5938 66.0741L49.6566 66.1273C49.9445 66.3709 50.2768 66.5038 50.6754 66.5038C51.0077 66.5038 51.2956 66.3709 51.5392 66.1051C51.7829 65.8394 51.8936 65.4628 51.8936 64.9756C51.8936 64.5105 51.7607 64.1561 51.5392 63.9124C51.3177 63.6688 50.9855 63.5581 50.5868 63.5581ZM83.3885 63.5581C82.9234 63.5581 82.414 63.7353 81.9046 64.0896C81.3952 64.444 80.7972 65.1306 80.1106 66.1937V63.8682H75.9245V64.2668C76.2789 64.3111 76.5225 64.3776 76.6554 64.4662C76.7883 64.5547 76.899 64.7098 76.9655 64.9091C77.0319 65.0642 77.0541 65.4407 77.0541 66.0165V71.6865C77.0541 72.5725 76.9655 73.1262 76.8105 73.3255C76.6554 73.5248 76.3453 73.6577 75.9024 73.6799V74.0786H81.4395V73.6799C81.0408 73.6577 80.7529 73.5913 80.5757 73.5027C80.3985 73.4141 80.2656 73.2591 80.177 73.0597C80.1327 72.949 80.0884 72.6832 80.0884 72.2624V71.6422V69.2945C80.0884 68.4307 80.1992 67.6555 80.4428 66.9468C80.5978 66.4817 80.8193 66.1273 81.1294 65.8837C81.3287 65.7286 81.5281 65.64 81.7274 65.64C81.816 65.64 81.9046 65.6622 81.971 65.7065C82.0056 65.7237 82.1209 65.8218 82.3065 65.9797L82.3068 65.9799L82.3073 65.9803L82.3941 66.0541L82.4804 66.1273C82.7684 66.3709 83.1006 66.5038 83.4771 66.5038C83.8093 66.5038 84.0973 66.3709 84.3409 66.1051C84.5845 65.8394 84.6953 65.4628 84.6953 64.9756C84.6953 64.5105 84.5845 64.1561 84.3409 63.9124C84.1194 63.6688 83.7872 63.5581 83.3885 63.5581ZM90.321 63.5581C91.2069 63.5581 92.0264 63.7796 92.8016 64.2447C93.5546 64.6876 94.1526 65.3521 94.5513 66.1937C94.95 67.0575 95.1493 67.9877 95.1493 68.9844C95.1493 70.4462 94.7728 71.6644 94.0419 72.6389C93.1338 73.8128 91.8935 74.4108 90.3431 74.4108C88.7927 74.4108 87.6189 73.8792 86.7772 72.794C85.9577 71.7087 85.5369 70.4905 85.5369 69.0287C85.5369 67.5669 85.9799 66.2823 86.8215 65.1971C87.6632 64.1118 88.837 63.5581 90.321 63.5581ZM91.1183 73.3698C91.4062 73.1262 91.6056 72.7718 91.6942 72.3288C91.8492 71.6422 91.9157 70.2247 91.9378 68.1206C91.9378 66.8803 91.8714 66.0387 91.7385 65.5736C91.5834 65.1085 91.3841 64.7762 91.1183 64.5547C90.919 64.3997 90.6754 64.3333 90.3653 64.3333C89.9888 64.3333 89.6787 64.4662 89.4129 64.7541C89.1471 65.042 88.9699 65.5957 88.8813 66.4152C88.7927 67.2347 88.7484 68.3864 88.7484 69.8704C88.7484 70.6456 88.7927 71.3765 88.9035 72.0631C88.9699 72.5725 89.1471 72.9711 89.4129 73.2369C89.6565 73.5027 89.9666 73.6356 90.2988 73.6356C90.6311 73.6356 90.8968 73.547 91.1183 73.3698ZM106.645 71.8638V63.846H102.481V64.2447C102.924 64.3112 103.234 64.4219 103.367 64.6212C103.499 64.8206 103.588 65.2857 103.588 66.0609V71.5315C103.167 72.1074 102.835 72.4839 102.525 72.6833C102.303 72.8161 102.082 72.8826 101.816 72.8826C101.617 72.8826 101.44 72.8383 101.285 72.7276C101.13 72.6168 101.019 72.4618 100.952 72.2403C100.886 72.0188 100.842 71.5537 100.842 70.8228V63.8239H96.6777V64.2226C97.1207 64.289 97.4308 64.3998 97.5637 64.5991C97.6966 64.7984 97.7852 65.2635 97.7852 66.0387V70.0919C97.7852 71.2658 97.8738 72.1074 98.0066 72.5725C98.1395 73.0376 98.4496 73.4585 98.9147 73.8128C99.3577 74.1672 99.8893 74.3444 100.465 74.3444C101.063 74.3444 101.617 74.2115 102.104 73.9457C102.591 73.6799 103.079 73.2591 103.566 72.6611V74.0343H107.73V73.6356C107.287 73.5913 106.977 73.4585 106.844 73.2813C106.711 73.1041 106.667 72.639 106.645 71.8638ZM116.102 63.5581C116.855 63.5581 117.542 63.8017 118.162 64.2668C118.76 64.7319 119.247 65.3742 119.513 66.2159C119.845 67.0575 120 67.9435 120 68.918C120 69.959 119.845 70.8892 119.513 71.753C119.181 72.6168 118.693 73.2812 118.073 73.7242C117.453 74.1672 116.744 74.3886 115.969 74.3886C115.415 74.3886 114.884 74.2558 114.396 74.0121C114.02 73.8128 113.643 73.5027 113.245 73.0376V76.8471C113.245 77.3565 113.289 77.7109 113.378 77.9102C113.466 78.1096 113.599 78.2425 113.776 78.3311C113.953 78.4196 114.308 78.4639 114.817 78.4639V78.8626H108.97V78.4639C109.413 78.4639 109.745 78.3311 109.967 78.0874C110.122 77.9102 110.188 77.4894 110.188 76.7807V65.9723C110.188 65.2635 110.122 64.7984 109.945 64.599C109.767 64.3776 109.457 64.2668 108.97 64.2447V63.846H113.245V65.1971C113.621 64.6876 113.976 64.289 114.352 64.0675C114.884 63.7353 115.482 63.5581 116.102 63.5581ZM115.282 73.2812C115.681 73.2812 115.991 73.0819 116.257 72.6611C116.633 72.0409 116.811 70.9335 116.811 69.1616C116.811 67.3897 116.611 66.1716 116.19 65.5293C115.925 65.1085 115.548 64.887 115.083 64.887C114.352 64.887 113.732 65.4185 113.267 66.4817V71.9523C113.887 72.8383 114.574 73.2812 115.282 73.2812ZM72.6688 25.9945H61.5282L57.9401 17.4895L56.8327 14.8539H67.9955L72.6688 25.9945ZM93.6435 42.6943L96.7 49.959C96.8329 50.3134 96.8993 50.6677 96.9215 51.0664C96.9215 52.6168 95.659 53.8571 94.1308 53.8571H48.195H47.2426C46.1573 53.8571 45.2271 53.237 44.762 52.3289C44.762 52.3178 44.7565 52.3123 44.7509 52.3067C44.7454 52.3012 44.7398 52.2957 44.7398 52.2846L44.6291 52.0188C44.6164 52.0061 44.611 52.0006 44.6087 51.9941C44.607 51.9893 44.607 51.9839 44.607 51.9745L40.7088 42.6943L39.535 39.9036L37.0544 33.99L34.8617 28.763L34.2637 27.3676V53.835H23.123V0.922453H34.2637L37.0986 7.54482L39.0034 12.0631L40.1773 14.8538L44.8727 25.9944L46.0466 28.7851L48.2393 34.0122L50.7199 39.9258L51.0078 40.6124L51.1407 40.9446C51.1518 40.9667 51.1629 40.9944 51.174 41.0221C51.185 41.0498 51.1961 41.0775 51.2072 41.0996L51.8716 42.6943H53.6214H53.7099H53.7985H89.3689H89.4575H89.546C91.03 42.65 92.226 41.4097 92.226 39.9036C92.226 39.5313 92.161 39.1806 92.0311 38.873L92.4696 39.9036L93.6435 42.6943Z"*/}
                            {/*        />*/}
                            {/*    </g>*/}
                            {/*</svg>*/}
                            <svg width="120" height="79" viewBox="0 0 120 79" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fillRule="evenodd" clipRule="evenodd"
                                      d="M91.0078 37.6224C91.0299 37.4674 91.052 37.3124 91.052 37.1352C91.052 36.7808 90.9856 36.4264 90.8527 36.1385L90.8084 36.0277V36.0056L87.7741 28.7852L86.6002 25.9945L81.9048 14.8539H70.7641L75.4596 25.9945L76.0354 27.3677L76.6334 28.7631H59.9114L58.7375 25.9724L54.5293 16.0056V15.9834L54.4629 15.8506V15.8284C54.3522 15.5183 54.2857 15.1861 54.2857 14.8539C54.2857 13.7686 54.8837 12.8384 55.7918 12.3733C56.1462 12.1739 56.5449 12.0632 56.9657 12.0632H57.0543H57.1429H66.7996L64.8948 7.54491L62.0819 0.900391H41.2182C39.6678 0.900391 38.4275 2.1407 38.4275 3.69109C38.4275 4.08976 38.5161 4.44413 38.6489 4.77636L38.7375 4.9757C38.7375 4.98677 38.7431 4.99231 38.7486 4.99784C38.7542 5.00338 38.7597 5.00892 38.7597 5.01999L41.7276 12.041L42.9014 14.8317L47.5969 25.9724L48.7708 28.7631L50.9635 33.9901L52.4252 37.4452L52.7575 38.2204C53.1783 39.2171 54.175 39.9259 55.3267 39.9259H88.3499C89.701 39.8816 90.7863 38.907 91.0078 37.6224ZM80.7309 12.0631H69.5903L64.8948 0.922453H76.0354L80.7309 12.0631ZM67.9734 68.2536H67.5969L67.5526 67.8328H74.773V68.2314C74.2193 68.2536 73.8206 68.3422 73.6213 68.4529C73.4219 68.5636 73.2447 68.7408 73.134 69.0066C73.0454 69.1395 73.0233 69.4939 73.0233 70.0254V73.1041C72.0709 73.5249 71.0742 73.835 70.0554 74.0564C69.0365 74.2779 67.9734 74.3887 66.866 74.3887C65.4707 74.3887 64.2968 74.1893 63.3666 73.8128C62.4363 73.4363 61.6168 72.9269 60.9081 72.3067C60.1993 71.6866 59.6456 70.9778 59.247 70.2026C58.7154 69.1838 58.4718 68.0542 58.4718 66.8139C58.4718 64.5769 59.247 62.6943 60.8195 61.1439C62.392 59.6157 64.3854 58.8405 66.7553 58.8405C67.4862 58.8405 68.1506 58.9069 68.7486 59.0177C69.0587 59.062 69.5903 59.2392 70.299 59.505C71.0299 59.7929 71.4507 59.9258 71.5836 59.9258C71.8051 59.9258 71.9823 59.8593 72.1595 59.7043C72.3367 59.5493 72.4917 59.2835 72.6467 58.8627H73.0454V64.0897H72.6467C72.1595 62.6722 71.4286 61.5869 70.454 60.8339C69.4795 60.103 68.35 59.7264 67.2425 59.7264C66.1351 59.7264 65.2049 60.0365 64.474 60.6567C63.7209 61.2768 63.2115 62.1628 62.9014 63.2702C62.5914 64.3776 62.4363 65.5293 62.4363 66.7032C62.4363 68.1207 62.6135 69.3831 62.9457 70.4463C63.278 71.5315 63.8317 72.3067 64.5626 72.8161C65.2935 73.3256 66.2016 73.5692 67.2204 73.5692C67.5748 73.5692 67.9513 73.547 68.3278 73.4584C68.7043 73.392 69.0808 73.2813 69.4795 73.1262V70.0476C69.4795 69.4717 69.4574 69.0952 69.3688 68.918C69.3023 68.7408 69.1251 68.5858 68.8815 68.4529C68.6379 68.32 68.3278 68.2536 67.9734 68.2536ZM40.9301 60.5902C40.9301 61.0553 40.7751 61.454 40.4429 61.7862C40.1107 62.1184 39.712 62.2735 39.2469 62.2735C38.7817 62.2735 38.3831 62.1184 38.0509 61.7862C37.7186 61.454 37.5636 61.0553 37.5636 60.5902C37.5636 60.1251 37.7186 59.7264 38.0509 59.3942C38.3831 59.0841 38.7817 58.9069 39.2469 58.9069C39.712 58.9069 40.1107 59.0619 40.4429 59.3942C40.7751 59.7264 40.9301 60.1251 40.9301 60.5902ZM10.454 59.6378C11.2735 59.6157 11.8715 59.8371 12.2259 60.258C12.4917 60.568 12.6024 61.166 12.6024 62.0741V68.4529L5.27132 59.2391H0V59.6378C0.442968 59.66 0.797342 59.7264 1.04097 59.8371C1.28461 59.97 1.55039 60.2137 1.88261 60.6123L2.19269 61.011V71.4872C2.19269 72.2845 2.03765 72.8382 1.70543 73.1705C1.3732 73.5027 0.819491 73.6577 0 73.6799V74.0786H5.27132V73.6799H4.91694C4.40753 73.6799 3.96456 73.5248 3.56589 73.2369C3.16722 72.949 2.99003 72.351 2.99003 71.5093V62.0741L13.0233 74.4329H13.3998V62.0741C13.3998 61.3654 13.4662 60.8781 13.577 60.5902C13.6877 60.3023 13.8649 60.1029 14.0864 59.97C14.3079 59.8371 14.7287 59.7486 15.3488 59.66V59.2613H10.454V59.6378ZM25.8692 72.8383C25.7806 72.8383 25.692 72.8161 25.6255 72.7497C25.5591 72.6832 25.4926 72.5946 25.4705 72.4839C25.4262 72.3731 25.4262 72.0631 25.4262 71.5979V67.6334C25.4262 66.526 25.3819 65.8172 25.2711 65.5293C25.094 65.042 24.7396 64.599 24.1637 64.1782C23.5879 63.7574 22.8348 63.5581 21.8603 63.5581C21.063 63.5581 20.2878 63.691 19.5347 63.9346C18.7817 64.2004 18.2058 64.5548 17.785 65.042C17.3642 65.5293 17.1648 66.0165 17.1648 66.5481C17.1648 66.9246 17.3199 67.2347 17.6299 67.5226C17.94 67.8106 18.3166 67.9435 18.7817 67.9435C19.2025 67.9435 19.5569 67.8106 19.8226 67.5669C20.0884 67.3233 20.2213 67.0132 20.2213 66.6588C20.2213 66.3709 20.0884 66.0608 19.8005 65.7508C19.6012 65.5293 19.4904 65.3299 19.4904 65.1749C19.4904 64.9977 19.579 64.8427 19.7783 64.7098C20.0884 64.4883 20.4871 64.3997 20.9522 64.3997C21.2401 64.3997 21.5059 64.4662 21.7496 64.6212C21.9932 64.7762 22.1482 64.9534 22.2368 65.1528C22.3254 65.3521 22.3697 65.8394 22.3697 66.6146V67.6334C20.1106 68.6744 18.6488 69.4938 17.9843 70.114C17.3199 70.7342 16.9876 71.4429 16.9876 72.2181C16.9876 72.794 17.187 73.2812 17.5635 73.6577C17.94 74.0343 18.4273 74.2336 19.0253 74.2336C20.022 74.2336 21.1294 73.6799 22.3919 72.5725C22.4583 73.1262 22.6576 73.547 22.9899 73.8128C23.3221 74.0786 23.7651 74.2336 24.3631 74.2336C24.8503 74.2336 25.2933 74.1229 25.692 73.8792C26.0906 73.6356 26.4672 73.2369 26.8215 72.7054L26.4893 72.4396C26.2457 72.7054 26.0685 72.8383 25.8692 72.8383ZM22.3476 71.7751C21.8603 72.1959 21.4395 72.3953 21.0851 72.3953C20.7529 72.3953 20.5092 72.2845 20.3099 72.1074C20.0663 71.8637 19.9555 71.5536 19.9555 71.2214C19.9555 70.8227 20.0884 70.4241 20.3764 70.0254C20.7972 69.4274 21.4616 68.8737 22.3476 68.3643V71.7751ZM30.5428 65.9502C30.7864 66.2382 31.4287 66.7476 32.514 67.4785C33.5993 68.2094 34.308 68.8074 34.6181 69.3168C34.9503 69.8262 35.1275 70.4021 35.1275 71.0222C35.1275 71.5981 34.9946 72.1518 34.7067 72.7055C34.4188 73.2592 34.0201 73.68 33.5107 73.9679C32.9791 74.2559 32.4033 74.4109 31.7831 74.4109C31.2737 74.4109 30.6314 74.2559 29.8119 73.9458L29.729 73.9208L29.729 73.9208C29.5562 73.8685 29.4459 73.8351 29.3689 73.8351C29.1253 73.8351 28.926 74.0344 28.7709 74.3888H28.4166L28.2394 70.7121H28.6159C28.9481 71.6867 29.3911 72.3954 29.967 72.8827C30.5207 73.3699 31.0744 73.6136 31.5838 73.6136C31.9382 73.6136 32.2261 73.5028 32.4476 73.2813C32.6691 73.082 32.7798 72.8162 32.7798 72.5062C32.7798 72.1518 32.6691 71.8417 32.4476 71.5981C32.2261 71.3544 31.7388 70.9558 30.9858 70.4464C29.8784 69.6712 29.1475 69.0732 28.8152 68.6745C28.328 68.0543 28.0843 67.412 28.0843 66.6811C28.0843 65.8838 28.3723 65.175 28.9038 64.5327C29.4354 63.8904 30.2327 63.5803 31.2516 63.5803C31.8053 63.5803 32.359 63.7132 32.8684 63.979C33.0677 64.0898 33.2228 64.1341 33.3557 64.1341C33.4885 64.1341 33.5771 64.0898 33.6657 64.0455C33.7322 64.0012 33.8651 63.824 34.0423 63.5803H34.4188L34.5738 67.0798H34.1973C33.7543 66.0388 33.3114 65.3301 32.8241 64.9536C32.359 64.577 31.8717 64.3777 31.4066 64.3777C31.0965 64.3777 30.8307 64.4884 30.6314 64.6878C30.4321 64.8871 30.3213 65.1086 30.3213 65.3744C30.3213 65.5737 30.3878 65.773 30.5428 65.9502ZM40.7751 71.9745V63.8682H36.4783V64.2669C36.9656 64.2891 37.2757 64.3998 37.4529 64.6213C37.63 64.8206 37.6965 65.2857 37.6965 65.9945V71.9745C37.6965 72.7054 37.63 73.1484 37.475 73.3034C37.2535 73.5471 36.9213 73.68 36.4562 73.7021V74.1008H41.9933V73.7021C41.506 73.68 41.1738 73.5692 41.0187 73.3477C40.8416 73.1484 40.7751 72.6833 40.7751 71.9745ZM50.5868 63.5581C50.1217 63.5581 49.6123 63.7353 49.1029 64.0896C48.5935 64.444 47.9955 65.1306 47.3089 66.1937V63.8682H43.1228V64.2668C43.4772 64.3111 43.7208 64.3776 43.8537 64.4662C43.9866 64.5547 44.0974 64.7098 44.1638 64.9091C44.2303 65.0642 44.2524 65.4407 44.2524 66.0165V71.6865C44.2524 72.5725 44.1638 73.1262 44.0088 73.3255C43.8537 73.5248 43.5437 73.6577 43.1007 73.6799V74.0786H48.6378V73.6799C48.2391 73.6577 47.9512 73.5913 47.774 73.5027C47.5968 73.4141 47.4639 73.2591 47.3753 73.0597C47.331 72.949 47.2867 72.6832 47.2867 72.2624L47.2646 71.6422V69.2945C47.2646 68.4307 47.3753 67.6555 47.619 66.9468C47.774 66.4817 47.9955 66.1273 48.3056 65.8837C48.5049 65.7286 48.7042 65.64 48.9036 65.64C48.9922 65.64 49.0808 65.6622 49.1472 65.7065C49.1818 65.7238 49.2974 65.8221 49.4836 65.9804L49.5938 66.0741L49.6566 66.1273C49.9445 66.3709 50.2768 66.5038 50.6754 66.5038C51.0077 66.5038 51.2956 66.3709 51.5392 66.1051C51.7829 65.8394 51.8936 65.4628 51.8936 64.9756C51.8936 64.5105 51.7607 64.1561 51.5392 63.9124C51.3177 63.6688 50.9855 63.5581 50.5868 63.5581ZM83.3885 63.5581C82.9234 63.5581 82.414 63.7353 81.9046 64.0896C81.3952 64.444 80.7972 65.1306 80.1106 66.1937V63.8682H75.9245V64.2668C76.2789 64.3111 76.5225 64.3776 76.6554 64.4662C76.7883 64.5547 76.899 64.7098 76.9655 64.9091C77.0319 65.0642 77.0541 65.4407 77.0541 66.0165V71.6865C77.0541 72.5725 76.9655 73.1262 76.8105 73.3255C76.6554 73.5248 76.3453 73.6577 75.9024 73.6799V74.0786H81.4395V73.6799C81.0408 73.6577 80.7529 73.5913 80.5757 73.5027C80.3985 73.4141 80.2656 73.2591 80.177 73.0597C80.1327 72.949 80.0884 72.6832 80.0884 72.2624V71.6422V69.2945C80.0884 68.4307 80.1992 67.6555 80.4428 66.9468C80.5978 66.4817 80.8193 66.1273 81.1294 65.8837C81.3287 65.7286 81.5281 65.64 81.7274 65.64C81.816 65.64 81.9046 65.6622 81.971 65.7065C82.0056 65.7237 82.1209 65.8218 82.3065 65.9797L82.3068 65.9799L82.3073 65.9803L82.3941 66.0541L82.4804 66.1273C82.7684 66.3709 83.1006 66.5038 83.4771 66.5038C83.8093 66.5038 84.0973 66.3709 84.3409 66.1051C84.5845 65.8394 84.6953 65.4628 84.6953 64.9756C84.6953 64.5105 84.5845 64.1561 84.3409 63.9124C84.1194 63.6688 83.7872 63.5581 83.3885 63.5581ZM90.321 63.5581C91.2069 63.5581 92.0264 63.7796 92.8016 64.2447C93.5546 64.6876 94.1526 65.3521 94.5513 66.1937C94.95 67.0575 95.1493 67.9877 95.1493 68.9844C95.1493 70.4462 94.7728 71.6644 94.0419 72.6389C93.1338 73.8128 91.8935 74.4108 90.3431 74.4108C88.7927 74.4108 87.6189 73.8792 86.7772 72.794C85.9577 71.7087 85.5369 70.4905 85.5369 69.0287C85.5369 67.5669 85.9799 66.2823 86.8215 65.1971C87.6632 64.1118 88.837 63.5581 90.321 63.5581ZM91.1183 73.3698C91.4062 73.1262 91.6056 72.7718 91.6942 72.3288C91.8492 71.6422 91.9157 70.2247 91.9378 68.1206C91.9378 66.8803 91.8714 66.0387 91.7385 65.5736C91.5834 65.1085 91.3841 64.7762 91.1183 64.5547C90.919 64.3997 90.6754 64.3333 90.3653 64.3333C89.9888 64.3333 89.6787 64.4662 89.4129 64.7541C89.1471 65.042 88.9699 65.5957 88.8813 66.4152C88.7927 67.2347 88.7484 68.3864 88.7484 69.8704C88.7484 70.6456 88.7927 71.3765 88.9035 72.0631C88.9699 72.5725 89.1471 72.9711 89.4129 73.2369C89.6565 73.5027 89.9666 73.6356 90.2988 73.6356C90.6311 73.6356 90.8968 73.547 91.1183 73.3698ZM106.645 71.8638V63.846H102.481V64.2447C102.924 64.3112 103.234 64.4219 103.367 64.6212C103.499 64.8206 103.588 65.2857 103.588 66.0609V71.5315C103.167 72.1074 102.835 72.4839 102.525 72.6833C102.303 72.8161 102.082 72.8826 101.816 72.8826C101.617 72.8826 101.44 72.8383 101.285 72.7276C101.13 72.6168 101.019 72.4618 100.952 72.2403C100.886 72.0188 100.842 71.5537 100.842 70.8228V63.8239H96.6777V64.2226C97.1207 64.289 97.4308 64.3998 97.5637 64.5991C97.6966 64.7984 97.7852 65.2635 97.7852 66.0387V70.0919C97.7852 71.2658 97.8738 72.1074 98.0066 72.5725C98.1395 73.0376 98.4496 73.4585 98.9147 73.8128C99.3577 74.1672 99.8893 74.3444 100.465 74.3444C101.063 74.3444 101.617 74.2115 102.104 73.9457C102.591 73.6799 103.079 73.2591 103.566 72.6611V74.0343H107.73V73.6356C107.287 73.5913 106.977 73.4585 106.844 73.2813C106.711 73.1041 106.667 72.639 106.645 71.8638ZM116.102 63.5581C116.855 63.5581 117.542 63.8017 118.162 64.2668C118.76 64.7319 119.247 65.3742 119.513 66.2159C119.845 67.0575 120 67.9435 120 68.918C120 69.959 119.845 70.8892 119.513 71.753C119.181 72.6168 118.693 73.2812 118.073 73.7242C117.453 74.1672 116.744 74.3886 115.969 74.3886C115.415 74.3886 114.884 74.2558 114.396 74.0121C114.02 73.8128 113.643 73.5027 113.245 73.0376V76.8471C113.245 77.3565 113.289 77.7109 113.378 77.9102C113.466 78.1096 113.599 78.2425 113.776 78.3311C113.953 78.4196 114.308 78.4639 114.817 78.4639V78.8626H108.97V78.4639C109.413 78.4639 109.745 78.3311 109.967 78.0874C110.122 77.9102 110.188 77.4894 110.188 76.7807V65.9723C110.188 65.2635 110.122 64.7984 109.945 64.599C109.767 64.3776 109.457 64.2668 108.97 64.2447V63.846H113.245V65.1971C113.621 64.6876 113.976 64.289 114.352 64.0675C114.884 63.7353 115.482 63.5581 116.102 63.5581ZM115.282 73.2812C115.681 73.2812 115.991 73.0819 116.257 72.6611C116.633 72.0409 116.811 70.9335 116.811 69.1616C116.811 67.3897 116.611 66.1716 116.19 65.5293C115.925 65.1085 115.548 64.887 115.083 64.887C114.352 64.887 113.732 65.4185 113.267 66.4817V71.9523C113.887 72.8383 114.574 73.2812 115.282 73.2812ZM72.6688 25.9945H61.5282L57.9401 17.4895L56.8327 14.8539H67.9955L72.6688 25.9945ZM93.6435 42.6943L96.7 49.959C96.8329 50.3134 96.8993 50.6677 96.9215 51.0664C96.9215 52.6168 95.659 53.8571 94.1308 53.8571H48.195H47.2426C46.1573 53.8571 45.2271 53.237 44.762 52.3289C44.762 52.3178 44.7565 52.3123 44.7509 52.3067C44.7454 52.3012 44.7398 52.2957 44.7398 52.2846L44.6291 52.0188C44.6164 52.0061 44.611 52.0006 44.6087 51.9941C44.607 51.9893 44.607 51.9839 44.607 51.9745L40.7088 42.6943L39.535 39.9036L37.0544 33.99L34.8617 28.763L34.2637 27.3676V53.835H23.123V0.922453H34.2637L37.0986 7.54482L39.0034 12.0631L40.1773 14.8538L44.8727 25.9944L46.0466 28.7851L48.2393 34.0122L50.7199 39.9258L51.0078 40.6124L51.1407 40.9446C51.1518 40.9667 51.1629 40.9944 51.174 41.0221C51.185 41.0498 51.1961 41.0775 51.2072 41.0996L51.8716 42.6943H53.6214H53.7099H53.7985H89.3689H89.4575H89.546C91.03 42.65 92.226 41.4097 92.226 39.9036C92.226 39.5313 92.161 39.1806 92.0311 38.873L92.4696 39.9036L93.6435 42.6943Z"
                                      fill="white"/>
                            </svg>
                        </Link>
                    </div>
                    <div className="main-menu__items__right">
                        <div className="hamburger slide">
                            <span/>
                            <span/>
                            <span/>
                        </div>
                    </div>
                </div>
            </Container>
            {/*menu item slide */}
            <div className="slide-menu">
                {/*<CloseButton/>*/}
                <div className={'menu-close'}>
                    <p>Close</p>
                    <div className="spans">
                        <span></span>
                        <span></span>
                    </div>
                </div>

                <ul>
                    <Accordion>
                        {
                            getMenus?.data && getMenus?.data?.length > 0 &&
                            getMenus?.data?.map((item, index) => {
                                return (
                                    <li className={location === item?.item_url || `/${slug}` === item?.item_url ? "active" : ""}
                                        key={index}>
                                        <Link prefetch={true}
                                              href={item?.item_url}>{reactHtmlParser(item?.item_title)}</Link>
                                    </li>
                                );
                            })
                        }
                        {/*<Accordion.Item*/}
                        {/*    className={*/}
                        {/*        location === "/about" ||*/}
                        {/*        location === "/leaders"*/}
                        {/*            ? "active"*/}
                        {/*            : ""*/}
                        {/*    }*/}
                        {/*    eventKey="0"*/}
                        {/*>*/}
                        {/*    <Accordion.Header>*/}
                        {/*        <span>Industries</span>{" "}*/}
                        {/*        <img src="/images/static/caret-down.svg" alt=""/>*/}
                        {/*    </Accordion.Header>*/}
                        {/*    <Accordion.Body>*/}
                        {/*        <ul>*/}
                        {/*            <li>*/}
                        {/*                <Link prefetch={true} href={"/about"}>CORPORATE INFO</Link>*/}
                        {/*            </li>*/}
                        {/*            <li>*/}
                        {/*                <Link prefetch={true} href={"/leaders"}>OUR LEADERS</Link>*/}
                        {/*            </li>*/}
                        {/*            <li>*/}
                        {/*                <Link prefetch={true} href={"/awards"}>Awards & Accolades </Link>*/}
                        {/*            </li>*/}
                        {/*        </ul>*/}
                        {/*    </Accordion.Body>*/}
                        {/*</Accordion.Item>*/}
                    </Accordion>
                </ul>
            </div>

        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    height: 100px;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    z-index: 9999;
    display: flex;
    justify-content: space-between;
    transition: all 0.6s cubic-bezier(0.4, 0, 0, 1);
    //background-color: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(5px);
    opacity: 1;

    .menu-overlay {
        position: fixed;
        height: 100svh;
        width: 100vw;
        background-color: rgba(0, 0, 0, 0.8);
        z-index: 999;
        inset: 0;
        display: none;
        opacity: 0;
        backdrop-filter: blur(25px);
    }


    .main-menu {
        &__items {
            height: 100px;
            display: flex;
            justify-content: space-between;
            align-items: center;

            &__left {
                svg {
                    max-height: 70px;
                    width: 100%;
                    // fill: none;
                        // stroke: ${p => p.textColor || 'transparent'};

                    path {
                        fill: ${p => p.textColor || 'transparent'};
                        transition: all 0.6s ease-in-out;
                    }

                    //g {
                    //    &:nth-of-type(2) {
                    //        fill: currentColor;
                    //        stroke: transparent;
                    //        animation: qode-logo 4s infinite forwards;
                    //        -webkit-clipPath: inset(0 100% 0 0);
                    //        clipPath: inset(0 100% 0 0);
                    //    }
                    //}
                }
            }

            @keyframes qode-logo {
                0%, 30% {
                    -webkit-clipPath: inset(0 100% 0 0);
                    clipPath: inset(0 100% 0 0)
                }

                55%, 75% {
                    -webkit-clipPath: inset(0 0 0 0);
                    clipPath: inset(0 0 0 0)
                }

                100% {
                    -webkit-clipPath: inset(0 0 0 100%);
                    clipPath: inset(0 0 0 100%)
                }
            }

            &__right {
                .hamburger {
                    flex-direction: column;
                    align-items: flex-start;
                    //padding-left: 25px;
                    cursor: pointer;
                    padding: 10px;
                    border: 1px solid ${p => p.textColor || 'transparent'};
                    height: 50px;
                    width: 50px;
                    display: flex;
                    justify-content: center;
                    border-radius: 50%;

                    span {
                        height: 2px;
                        width: 25px;
                        background-color: ${p => p.textColor || 'transparent'};
                        border-radius: 2px;
                        display: block;
                        position: relative;
                        z-index: 2;
                        transition: all 0.6s cubic-bezier(0.4, 0, 0, 1);

                        &:nth-of-type(2) {
                            margin: 5px 0;
                            width: 15px;
                            transition: width 0.6s cubic-bezier(0.4, 0, 0, 1);
                        }

                        &:nth-of-type(3) {
                        }
                    }

                    &:hover {
                        span {
                            &:first-child {
                                width: 12px;
                                transition: width 0.6s cubic-bezier(0.4, 0, 0, 1);
                            }

                            &:nth-of-type(2) {
                                width: 18px;
                                transition: width 0.6s cubic-bezier(0.4, 0, 0, 1);
                            }

                            &:nth-of-type(3) {
                                width: 25px;
                                transition: width 0.6s cubic-bezier(0.4, 0, 0, 1);
                            }
                        }
                    }
                }
            }
        }
    }

    //slide menu

    .slide-menu {
        position: fixed;
        height: ${`100svh`};
        width: 460px;
        right: 0;
        z-index: 9999;
        background-color: rgba(0, 25, 143, 0.7);
        padding: 80px 100px;
        //display: flex;
        align-items: center;
        display: none;
        transform: translateX(100%);
        flex-wrap: wrap;

        &__close {
            position: absolute;
            right: 30px;
            top: 30px;
            cursor: pointer;
            z-index: 2;

            #Ellipse_637,
            line {
                transition: all 0.5s ease;
            }

            &:hover {
                line {
                    stroke: white;
                }

                #Ellipse_637 {
                    cy: -20;
                }

                #Group_23147 {
                    cy: -10;
                }
            }
        }

        .menu-close {
            top: 40px;
            right: 30px;
            position: absolute;
            width: 65px;
            cursor: pointer;

            p {
                font-size: 16px;
                line-height: 20px;
                font-weight: 500;
                color: #fff;
            }

            .spans {
                position: absolute;
                top: 0;
                bottom: 0px;
                right: 0;
                margin: auto;
                height: 15px;
                width: 15px;
                margin: auto;

                span {
                    height: 1px;
                    width: 15px;
                    background-color: #fff;
                    position: absolute;
                    top: 0;
                    bottom: 0;
                    margin: auto;
                    transition: all 0.4s ease;

                    &:nth-child(1) {
                        transform: rotate(45deg);
                    }

                    &:nth-child(2) {
                        transform: rotate(-45deg);
                    }
                }
            }

            &:hover {
                span {
                    transform: none !important;
                }
            }
        }

        .active a,
        .active span {
            border-bottom: 2px solid white;
            color: #ffffff;
        }

        a {
            font-size: 20px;
            line-height: 28px;
            color: rgba(245, 245, 245, 0.5);
            text-transform: uppercase;

            &:hover {
                color: rgb(245, 245, 245) !important;
            }
        }

        ul {
            width: 100%;

            li {
                &:not(:nth-last-child(1)) {
                    margin-bottom: 20px;
                }

                transform: translateY(20px);
                opacity: 0;
            }
        }

        .accordion-item {
            transform: translateY(20px);
            opacity: 0;

            a {
                border: none;
            }
        }

        .accordion-header {
            font-size: unset;

            button {
                background-color: transparent;
                padding: 0;
                box-shadow: none;
                border: none;
                font-size: 20px;
                line-height: 28px;
                color: rgba(245, 245, 245, 0.6);
                margin-bottom: 20px;
                transition: color 0.6s ease;
                width: 100%;
                text-align: left;
                position: relative;
                color: white;
                text-transform: uppercase;

                img {
                    position: absolute;
                    right: 0;
                    top: 11px;
                    transform: rotate(180deg);
                }

                &:hover {
                    color: rgb(245, 245, 245) !important;
                }

                &.collapsed {
                    color: rgba(245, 245, 245, 0.5);

                    img {
                        transform: rotate(0deg);
                    }
                }
            }
        }

        .accordion-body {
            margin-bottom: 20px;

            ul {
                padding-left: 20px;
            }

            a {
                font-size: 15px;
                line-height: 20px;
                color: white;
                text-transform: uppercase;

                &:hover {
                    color: rgba(245, 245, 245, 0.5) !important;
                }
            }
        }
    }


    @media (max-width: 767px) {

        .menu-overlay {
            height: 100svh;
        }

        .main-menu {
            &__items {
                height: 100%;
            }
        }

        .slide-menu {
            height: 100svh;
        }

        .slide-menu {
            padding-left: 30px;
            padding-right: 30px;
            padding-bottom: 30px;
            align-items: normal;
            overflow: auto;
            padding-top: 100px;
            height: 100svh;

            .goto-buttons {
                height: fit-content;

                img {
                    width: 100%;
                    display: block;

                    &:nth-of-type(1) {
                        margin-bottom: 20px;
                    }
                }
            }

            .accordion {
                margin-top: 30px;
            }
        }
    }

    @media (max-width: 500px) {
        .slide-menu {
            height: 120svh !important;
            width: 100%;
            padding-left: 15px;
            padding-right: 15px;
            padding-bottom: 40px;
            align-items: normal;
            overflow: auto;
            padding-top: 100px;
        }
    }

`;

export default MyComponent;
