"use client";
import React, {useEffect, useState} from 'react';
import styled from "styled-components";
import {Container, Row, Col, Accordion} from "react-bootstrap";
import {usePathname} from "next/navigation";
import Link from "next/link";
import Button from "@/components/Button";
import {title} from "@/styles/globalStyleVars";
import {getConcernApi} from "@/api/api";
import reactHtmlParser from "react-html-parser";

const MyMenu = ({bgColor, textColor}) => {

    const location = usePathname();
    const [activeMenuItem, setActiveMenuItem] = useState(null);

    const slug = location.split('/')[1];

    useEffect(() => {
        setActiveMenuItem(location);
    }, [location]);


    //Sticky Menu behavior
    const [scrollUp, setScrollUp] = useState(false)
    const [scrollDown, setScrollDown] = useState(false)

    useEffect(() => {
        const body = document.body;
        const scrollUp = "scroll-up";
        const scrollDown = "scroll-down";
        let lastScroll = 0;
        let howMuchScroll = 100;

        const handleScroll = () => {
            if (!document.querySelector('.menu').classList.contains('menu-active')) {
                let currentScroll = window.pageYOffset;

                if (currentScroll <= howMuchScroll) {
                    setScrollUp(false)
                    setScrollDown(false)

                    return;
                }
                if (currentScroll > lastScroll && !body.classList.contains(scrollDown)) {
                    setScrollDown(true)
                    setScrollUp(false)
                } else if (currentScroll < lastScroll && !body.classList.contains(scrollUp)) {
                    setScrollUp(true)
                    setScrollDown(false)
                }
                lastScroll = currentScroll;
            }
        };

        typeof window !== 'undefined' && window.addEventListener("scroll", handleScroll);

        return () => {
            typeof window !== 'undefined' && window.removeEventListener("scroll", handleScroll);
        };
    }, []);


    //toggle menu action
    useEffect(() => {
        const menuClickHandler = () => {
            document.body.classList.toggle('menu-open');
        };

        const hamClick = document.querySelector('.menu-desktop__hamburger');
        hamClick.addEventListener('click', menuClickHandler);

        return () => {
            hamClick.removeEventListener('click', menuClickHandler);
        };
    }, []);


    //close Hamburger menu when click on menu items
    useEffect(() => {
        const handleMenuItemClick = (event) => {
            const menuItems = document.querySelectorAll('.menu-mobile .menu-mobile__items li');
            // Remove menu-open class from body
            document.body.classList.remove('menu-open');
        };

        const menuItems = document.querySelectorAll('.menu-mobile .menu-mobile__items li');
        menuItems.forEach(item => {
            item.addEventListener('click', handleMenuItemClick);
        });

        return () => {
            menuItems.forEach(item => {
                item.removeEventListener('click', handleMenuItemClick);
            });
        };
    }, []);


    const [getConcerns, setConcerns] = useState(null);

    useEffect(() => {
        const fetchSetting = async () => {
            const data = await getConcernApi();
            setConcerns(data);
        };

        fetchSetting();
    }, []);


    return (
        <>
            <StyledComponent className={`menu ${scrollDown ? "scroll-down" : ""} ${scrollUp ? "scroll-up" : ""}`}
                             bgColor={bgColor} textColor={textColor}>
                <Container>
                    <div className={'menu-desktop'}>
                        <div className={'menu-desktop__logo'}>
                            <Link href={'/'} prefetch={true}>
                                <img src={'/images/logo-updated.png'} alt={'logo'}/>
                                {/*<svg width="245" height="40" viewBox="0 0 245 40" fill="none"*/}
                                {/*     xmlns="http://www.w3.org/2000/svg">*/}
                                {/*    <path fillRule="evenodd" clipRule="evenodd"*/}
                                {/*          d="M50.9568 24.8603L50.2794 25.7578C49.9577 26.1981 49.4496 26.4352 48.9077 26.4352L22.6249 26.0627C22.0152 26.0627 21.4564 25.724 21.1685 25.1821L7.75614 0.88061C7.45131 0.338696 6.89247 0 6.26588 0H0V31.2108H7.11262V14.4454L17.3074 31.0076C17.6122 31.4987 18.1372 31.8036 18.7299 31.8205L51.702 32.3285C52.9382 32.3455 53.7849 31.0584 53.26 29.9238L50.9568 24.8772V24.8603ZM79.7967 11.5495C82.6079 11.7189 83.1498 12.4301 83.2514 13.8865C83.3531 15.1397 83.3869 16.2574 83.3869 19.204V25.3006L70.4826 10.2963H63.878V11.5495C65.3006 11.685 66.1134 11.7866 66.7231 12.6333C67.3666 13.514 67.4343 14.2591 67.4343 15.3768V23.4039C67.4343 26.3505 67.3666 27.5698 67.2311 28.7891C67.0279 30.381 66.1812 30.8891 64.2506 31.0584V32.3116H72.6503V31.0584C70.1439 30.9229 69.4326 30.1439 69.2972 28.6537C69.1955 27.6714 69.1278 26.3505 69.1278 23.4039V15.7493L83.2514 32.6841H85.1481V19.204C85.1481 16.4098 85.2395 15.2298 85.3356 13.9888V13.9887L85.3514 13.7849C85.453 12.2608 86.0965 11.8205 88.1625 11.5495V10.2963H79.7967V11.5495ZM124.606 12.3624C124.606 13.6833 123.522 14.7672 122.134 14.7672C120.847 14.7672 119.695 13.7511 119.695 12.3624C119.695 10.9738 120.813 9.95767 122.168 9.95767C123.522 9.95767 124.606 10.9738 124.606 12.3624ZM39.9884 6.62149C40.7364 6.62149 41.2196 5.83032 40.878 5.16485L38.9579 1.42395C38.7867 1.09036 38.4432 0.880591 38.0682 0.880591H33.4793C32.7262 0.880591 32.2433 1.68156 32.595 2.34752L34.5703 6.08842C34.7434 6.41631 35.0838 6.62149 35.4546 6.62149H39.9884ZM26.8543 10.7472C26.5026 10.0813 26.9855 9.28029 27.7386 9.28029H32.3275C32.7025 9.28029 33.046 9.49006 33.2172 9.82366L35.1373 13.5646C35.4789 14.23 34.9956 15.0212 34.2476 15.0212H29.7138C29.343 15.0212 29.0027 14.816 28.8295 14.4881L26.8543 10.7472ZM22.7265 22.2185C23.0821 22.9467 23.8272 23.4209 24.6401 23.4209H46.7062C48.298 23.4209 49.3311 21.7104 48.569 20.3048L43.2684 10.398C42.8958 9.70366 42.1846 9.28029 41.4056 9.28029H36.7316L41.1515 17.68H28.5182C28.2133 17.68 27.9255 17.5106 27.773 17.2227L22.7773 7.84083C22.4724 7.28198 22.8789 6.60459 23.5224 6.60459H31.8374L28.7214 0.863693H15.9017C14.3437 0.863693 13.3277 2.48943 13.9881 3.89502L22.7265 22.2185ZM101.27 27.8747C101.27 29.5004 101.812 29.9069 102.354 29.9069C102.693 29.9069 103.031 29.8052 103.404 29.6359L103.777 30.7875L100.152 32.718C99.238 32.718 98.4929 32.4132 98.0525 32.0068C97.5784 31.6003 97.3413 31.1262 97.1719 30.7536L96.9614 30.8922L96.9613 30.8923C95.7094 31.7173 94.1907 32.718 93.5817 32.718C90.669 32.718 88.9755 30.4488 88.9755 28.3489C88.9755 26.5538 89.7884 25.7409 91.5835 25.0296C92.0687 24.8487 92.5938 24.6638 93.122 24.4778L93.1225 24.4776C94.7696 23.8976 96.4466 23.3071 97.0365 22.7942V21.304C97.0365 19.5428 96.3929 18.5605 94.9365 18.5605C94.3608 18.5605 93.8866 18.8315 93.5817 19.2379C93.2297 19.7074 93.0809 20.2785 92.8713 21.0835L92.8712 21.0836C92.8389 21.2078 92.8051 21.3375 92.7689 21.4733C92.5318 22.3878 91.9899 22.6249 91.3125 22.6249C90.4319 22.6249 89.3142 21.812 89.3142 20.8637C89.3142 20.254 89.7206 19.8137 90.4996 19.2718C92.0238 18.2557 94.0221 17.2735 95.9188 16.8671C97.2735 16.8671 98.4251 17.1719 99.4073 17.8493C100.864 18.8654 101.27 20.2879 101.27 22.0152V27.8747ZM95.5462 30.1101C96.0204 30.1101 96.4945 30.0762 97.0365 29.5682V24.1829L97.0344 24.184C96.4254 24.5223 95.8164 24.8607 95.1398 25.2328C94.0898 25.7748 93.4801 26.3844 93.4801 27.536C93.4801 29.4327 94.8011 30.1101 95.5462 30.1101ZM111.634 22.6249C109.873 21.8459 109.026 21.2024 109.026 20.0169C109.026 18.8992 109.873 18.2218 110.821 18.2218C112.413 18.2218 113.565 19.3057 114.445 21.6765L115.563 21.3717C115.428 20.4572 115.123 18.2896 115.021 17.3751C114.922 17.3536 114.816 17.3294 114.702 17.3035C113.918 17.1253 112.783 16.8671 111.363 16.8671C107.773 16.8671 105.572 18.967 105.572 21.6427C105.572 24.4538 107.739 25.6393 109.975 26.7231C112.075 27.7392 112.583 28.5182 112.583 29.5682C112.583 30.5504 111.939 31.3294 110.652 31.3294C108.451 31.3294 107.062 29.3311 106.351 27.1973L105.233 27.4005C105.335 28.5859 105.639 30.9229 105.775 31.7019C106.486 32.0406 108.315 32.718 110.076 32.718C113.023 32.718 116.241 31.0584 116.241 27.6715C116.241 24.9958 114.378 23.8442 111.634 22.6249ZM190.923 24.8942C190.923 19.7121 195.191 16.8671 199.086 16.8671C203.861 16.8671 206.876 20.4572 206.876 24.5216C206.876 29.9746 202.947 32.718 198.95 32.718C193.836 32.718 190.923 28.8569 190.923 24.8942ZM195.8 23.9119C195.8 28.1118 197.189 31.3294 199.323 31.3294C200.61 31.3294 201.998 30.4488 201.998 25.5038C201.998 20.7959 200.779 18.2218 198.679 18.2218C197.223 18.2218 195.8 19.7121 195.8 23.9119ZM224.522 28.0779V17.0364C222.828 17.3074 219.949 17.5445 217.985 17.6122V18.696L219.001 18.8992C219.949 19.0686 220.119 19.3395 220.119 20.8975V29.0601C219.373 29.8391 218.628 30.0423 217.68 30.0423C216.495 30.0423 215.377 29.2972 215.377 27.0957V22.1507C215.377 20.2201 215.411 18.4589 215.478 17.0364C213.582 17.3074 210.906 17.5445 209.179 17.6122V18.696L209.89 18.8992C210.804 19.1363 211.008 19.3057 211.008 20.8637V27.8747C211.008 30.8891 212.6 32.718 215.445 32.718C217.307 32.718 218.73 31.5665 220.119 30.4149V32.718C222.354 32.21 224.522 31.7697 226.554 31.4987V30.381L225.809 30.3133C224.725 30.2117 224.522 29.8391 224.522 28.0779ZM244.911 23.5394C244.911 28.4844 240.982 31.7697 236.613 32.7181C235.766 32.7181 234.987 32.6164 234.479 32.4132V36.4776C234.479 38.3743 234.649 38.5775 236.986 38.8823V40H227.909V38.8823C229.975 38.6791 230.11 38.3743 230.11 36.5114V21.4056C230.11 19.5766 229.907 19.3734 228.247 19.1702V18.0525C230.004 17.7874 232.214 17.1657 234.339 16.5679L234.339 16.5679L234.479 16.5284V18.967C234.502 18.9558 234.755 18.8052 235.089 18.6069C235.769 18.2029 236.782 17.6011 236.85 17.5783C237.697 17.0703 238.442 16.8671 239.052 16.8671C242.777 16.8671 244.911 20.2879 244.911 23.5394ZM236.613 19.475C235.766 19.475 235.055 19.8137 234.479 20.2202V29.8391C235.123 30.4827 236.376 31.0923 237.257 31.0923C239.052 31.0923 240.373 28.8908 240.373 25.2329C240.373 21.0669 238.307 19.475 236.613 19.475ZM187.231 16.8671C185.843 16.8671 184.623 18.1203 183.099 20.4573V16.7993C180.999 17.4429 179.103 17.8493 177.003 18.0864V19.1364C178.594 19.475 178.73 19.6444 178.73 21.3379V28.7553C178.73 30.7875 178.561 30.9568 176.766 31.1601V32.3116H185.707V31.1601C183.336 30.8891 183.099 30.7875 183.099 28.7553V22.3201C183.709 21.033 184.556 20.5927 185.064 20.5927C185.512 20.5927 185.878 20.9208 186.289 21.2898L186.289 21.2899L186.289 21.29C186.407 21.3952 186.528 21.5037 186.655 21.6088C186.893 21.812 187.231 21.9814 187.705 21.7782C188.247 21.5072 189.433 20.5589 189.433 18.8993C189.433 17.7138 188.484 16.8671 187.231 16.8671ZM124.572 16.8332V28.3827C124.572 30.6859 124.708 30.923 126.672 31.16V32.3116H118.171V31.16C120 30.923 120.203 30.7875 120.203 28.3827V21.7782C120.203 19.5089 120.034 19.3734 118.442 19.1702V18.0525C120.576 17.8154 122.71 17.3751 124.572 16.8332ZM138.696 16.8671C137.307 16.8671 136.088 18.1203 134.564 20.4573V16.7993C132.464 17.4429 130.567 17.8493 128.467 18.0864V19.1364C130.059 19.475 130.195 19.6444 130.195 21.3379V28.7553C130.195 30.7875 130.025 30.9568 128.23 31.1601V32.3116H137.172V31.1601C134.801 30.8891 134.564 30.7875 134.564 28.7553V22.3201C135.174 21.033 136.02 20.5927 136.528 20.5927C136.976 20.5927 137.342 20.9208 137.754 21.2898L137.754 21.2899C137.871 21.3951 137.992 21.5036 138.12 21.6088C138.357 21.812 138.696 21.9814 139.17 21.7782C139.712 21.5072 140.897 20.5589 140.897 18.8993C140.897 17.7138 139.949 16.8671 138.696 16.8671ZM167.756 25.978C167.756 23.6071 167.282 23.37 164.437 23.0313V21.7781H174.564V23.0313C172.633 23.37 172.396 23.5055 172.396 25.8086V28.4166C172.396 29.6359 172.43 30.7875 172.599 31.7019C172.303 31.7542 171.949 31.8214 171.55 31.8968C169.624 32.2616 166.676 32.8196 164.403 32.8196C156.444 32.8196 151.871 27.9763 151.871 21.2701C151.871 13.6494 158.069 9.82217 165.284 9.82217C167.209 9.82217 169.251 10.1557 170.684 10.3898C171.293 10.4893 171.792 10.5709 172.125 10.6012C172.193 12.0914 172.464 14.6655 172.701 16.5284L171.38 16.7654C170.567 13.8865 169.314 12.4301 167.214 11.7189C166.435 11.4479 165.182 11.3124 164.335 11.3124C160.237 11.3124 157.155 14.7333 157.155 20.6943C157.155 26.6554 159.255 31.3632 164.809 31.3632C165.487 31.3632 166.367 31.2616 166.977 30.8891C167.485 30.5842 167.756 30.0085 167.756 28.9585V25.978Z"*/}
                                {/*          fill="white"/>*/}
                                {/*</svg>*/}
                            </Link>
                        </div>
                        <div className={'menu-desktop__items'}>
                            <ul>
                                <li className={activeMenuItem === '/' ? 'active' : ''}>
                                    <Link href={'/'} prefetch={true}>
                                        Home
                                    </Link>
                                </li>
                                <li className={activeMenuItem === '/about-uss' ? 'active' : ''}>
                                    <Link href={'/about-uss'} prefetch={true}>
                                        About Us
                                    </Link>
                                </li>
                                <li className={activeMenuItem === '/industries' ? 'active' : ''}>
                                    <Link href={'/industries'} prefetch={true}>
                                        Industries
                                    </Link>
                                    {/*<div className={'inner-menu'}>*/}
                                    {/*    <ul>*/}
                                    {/*        {*/}
                                    {/*            getConcerns?.data?.list && getConcerns?.data?.list?.length > 0 &&*/}
                                    {/*            getConcerns?.data?.list?.map((item, index) => {*/}
                                    {/*                return (*/}
                                    {/*                    <li key={index}>*/}
                                    {/*                        <Link href={`/industries/${item?.page_data?.slug}`} prefetch={true}>*/}
                                    {/*                            {reactHtmlParser(item?.page_data?.title)}*/}
                                    {/*                        </Link>*/}
                                    {/*                    </li>*/}
                                    {/*                );*/}
                                    {/*            })*/}
                                    {/*        }*/}
                                    {/*    </ul>*/}
                                    {/*</div>*/}
                                </li>
                                <li className={activeMenuItem === '/news-media' || slug.startsWith('news-media') ? 'active' : ''}>
                                    <Link href={'/news-media'} prefetch={true}>
                                        News & Media
                                    </Link>
                                </li>
                                <li className={activeMenuItem === '/career' ? 'active' : ''}>
                                    <Link href={'/career'} prefetch={true}>
                                        Career
                                    </Link>
                                </li>
                                <li className={activeMenuItem === '/contact-us' ? 'active' : ''}>
                                    <Link href={'/contact-us'} prefetch={true}>
                                        Contact us
                                    </Link>
                                </li>
                            </ul>
                        </div>
                        <div className={'menu-desktop__hamburger'}>
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </Container>
            </StyledComponent>
            <StyledMobile>
                <div className={'menu-mobile'}>
                    <ul className={'menu-mobile__items'}>
                        <Accordion>
                            <li className={activeMenuItem === '/' ? 'active' : ''}>
                                <Link href={'/'} prefetch={true}>
                                    Home
                                </Link>
                            </li>
                            <li className={activeMenuItem === '/about-uss' ? 'active' : ''}>
                                <Link href={'/about-uss'} prefetch={true}>
                                    About Us
                                </Link>
                            </li>
                            <Accordion.Item eventKey="0">
                                <Accordion.Header>
                                    <span>Concerns</span>{" "}
                                    <img src="/images/static/mobile-caret.svg" alt="" />
                                </Accordion.Header>
                                <Accordion.Body>
                                    <ul>
                                        {
                                            getConcerns?.data?.list && getConcerns?.data?.list?.length > 0 &&
                                            getConcerns?.data?.list?.map((item, index) => {
                                                return (
                                                    <li key={index}>
                                                        <Link href={`/concerns/${item?.page_data?.slug}`} prefetch={true}>
                                                            {reactHtmlParser(item?.page_data?.title)}
                                                        </Link>
                                                    </li>
                                                );
                                            })
                                        }
                                    </ul>
                                </Accordion.Body>
                            </Accordion.Item>
                            <li className={activeMenuItem === '/news-media' ? 'active' : ''}>
                                <Link href={'/news-media'} prefetch={true}>
                                    News & Media
                                </Link>
                            </li>
                            <li className={activeMenuItem === '/career' ? 'active' : ''}>
                                <Link href={'/career'} prefetch={true}>
                                    Career
                                </Link>
                            </li>
                            <li className={activeMenuItem === '/contact-us' ? 'active' : ''}>
                                <Link href={'/contact-us'} prefetch={true}>
                                    Contact Us
                                </Link>
                            </li>
                        </Accordion>
                    </ul>
                </div>
            </StyledMobile>
        </>
    );
};

const StyledComponent = styled.section`
    position: fixed;
    top: 0;
    left: 0;
    z-index: 999;
    width: 100%;
    height: 80px;
    display: flex;
    align-items: center;
    background: ${p => p.bgColor || 'transparent'};;
    transition: all .3s ease;

    .container {
        //padding: 15px 0;
        padding-left: 0;
        padding-right: 0;
        //border-bottom: 1px solid rgba(255, 255, 255, 0.2);

        @media (max-width: 991px) {
            padding-left: 15px;
            padding-right: 20px;
        }
    }

    &.scroll-up {
        .container {
            border-bottom: 0 !important;

            .menu-desktop {
                &__logo {
                    svg {
                        //height: 80px !important;

                        path {
                            fill: #274DF9;
                        }
                    }
                }

                &__items {
                    ul {
                        li {
                            a {
                                &:hover {
                                    color: #25292C !important;
                                }

                                &:after {
                                    background-color: #25292C !important;
                                }
                            }
                        }
                    }
                }
            }
        }

        @media (max-width: 991px) {
            .container {
                .menu-desktop {
                    background-color: transparent !important;
                    &__logo{
                        width: 80%;
                    }
                }

                .menu-desktop__hamburger {
                    border: 1px solid #000000 !important;
                }
            }
        }
    }

    .menu-desktop {
        display: flex;
        justify-content: space-between;
        align-content: center;
        align-items: center;

        &__logo {
            img{
                max-width: 115px;
            }
            svg {
                //width: 100px;
                height: 80px;
                //margin-left: -20px;
            }
        }

        &__items {
            ul {
                display: flex;
                gap: 30px;
                align-items: center;

                li {
                    position: relative;
                    a {
                        position: relative;
                        color: #FFF;
                        text-align: center;
                        font-size: 15px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 100%; /* 14px */


                        &:hover {
                            color: #274DF9 !important;
                        }
                    }

                    &.active {
                        a {
                            color: #274DF9 !important;
                        }
                    }

                    .inner-menu{
                        position: absolute;
                        top: 20px;
                        left: -50%;
                        padding-top: 20px;
                        transform: translateY(8px);
                        opacity: 0;
                        visibility: hidden;
                        transition: 0.3s;
                        ul{
                            display: flex;
                            gap: 15px;
                            justify-content: space-between;
                            flex-direction: column;
                            flex-wrap: nowrap;
                            min-width: 370px;
                            //max-height: 350px;
                            background-color: rgb(255, 255, 255);
                            padding: 30px;
                            border-radius: 20px;
                            box-shadow: rgba(0, 0, 0, 0.06) 0px 0px 20px;

                            li{
                                font-size: 10px !important;
                                min-width: 100%;
                                margin: 0px !important;
                                border-bottom: 1px solid #274df94a;
                                padding-bottom: 10px;
                                a{
                                    font-size: 14px !important;
                                    color: rgb(0, 0, 0, 0.5);
                                    //padding-bottom: 10px;
                                    min-width: 100%;
                                    transition: all 0.3s ease;
                                }

                                &:hover{
                                    a{
                                        color: #274DF9;
                                        transition: all 0.3s ease;
                                    }
                                }
                            }
                        }
                    }

                    &:hover{
                        .inner-menu{
                            opacity: 1;
                            visibility: visible;
                            transform: none;
                        }
                    }
                }
            }
        }

        &__hamburger {
            display: none !important;
            opacity: 0 !important;
            width: 45px;
            height: 45px !important;
            background-color: #FFFFFF !important;
            border-radius: 50% !important;
            cursor: pointer;

            span {
                display: block;
                width: 15px;
                height: 1px;
                background-color: #040504;
                margin-bottom: 4px;
                border-radius: 5px;
                transition: 0.3s transform ease-in-out;

                &:last-child {
                    margin-bottom: 0 !important;
                }
            }
        }

        @media (max-width: 991px) {
            border-bottom: 1px solid rgba(254, 248, 238, 0.25) !important;
            &__items {
                display: none;
                opacity: 0;
            }

            &__hamburger {
                display: flex !important;
                flex-direction: column !important;
                justify-content: center !important;
                align-items: center !important;
                opacity: 1 !important;
            }
        }
    }

    &.scroll-down {
        transform: translate3d(0, -160px, 0);
    }

    &.scroll-up {
        background-color: #ffffff;
        border-bottom: 0px !important;

        .menu-desktop {
            &__items {
                ul {
                    li {
                        a {
                            color: #000000;
                        }
                    }
                }
            }
        }
    }
`;

const StyledMobile = styled.section`{

    .menu-mobile {

        position: fixed;
        top: 80px;
        display: none;
        opacity: 0;
        height: 0;
        width: 100% !important;
        z-index: 999;
        background-color: #25292C;
        background: radial-gradient(252% 110.16% at 24.49% 80.21%, #00167D 0%, #001A94 100%) !important;
        -webkit-backdrop-filter: blur(15px) !important;
        backdrop-filter: blur(15px) !important;
        transition: 0.6s height ease-in-out;
        //overflow: hidden;
        overflow-y: scroll;
        @media (max-width: 991px) {
            display: flex;
            justify-content: flex-start !important;
            opacity: 1;
            gap: 30px
        }

        ul {
            padding-left: 15px;
            padding-right: 15px;
            margin-top: 50px;
            width: 100%;
            height: 600px;
            overflow-y: scroll;
            padding-bottom: 150px;


            li {
                display: flex;
                text-align: left;
                position: relative;
                padding-bottom: 25px;
                margin-bottom: 25px;
                border-bottom: 1px solid rgba(255, 255, 255, 0.2);

                &:last-child {
                    margin-bottom: 0 !important;
                }

                a {
                    text-align: center;
                    font-size: 15px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 100%; /* 14px */
                    color: rgba(255, 255, 255, 0.8);
                    text-transform: Capitalize;
                    transition: 0.3s padding ease-in-out;

                    &:hover {
                        color: #fff !important;
                    }
                }

                &.active {
                    border-bottom: 1px solid rgba(255, 255, 255, 0.8);

                    a {
                        color: #ffffff !important;

                        &:hover {
                            color: #ffffff !important;
                        }
                    }

                    &:after {
                        width: 40px;
                        transition: width .5s ease-out;
                    }
                }
            }
        }
    }

    .accordion {
        margin-bottom: 80px;
    }
    .accordion-button {
        font-size: 15px;
        font-style: normal;
        font-weight: 400;
        line-height: 100%; /* 14px */
        color: rgba(255, 255, 255, 0.8);
        text-transform: Capitalize;
        background-color: transparent;
        width: 100%;
        border: none;
        box-shadow: none;
        text-align: left;
        padding: 0 0 25px 0;
        border-bottom: 1px solid rgba(255, 253, 250, 0.2);
        position: relative;
        margin-bottom: 30px;

        img {
            position: absolute;
            right: 0px;
            transform: rotate(90deg);
            border: 1px solid #fff;
            height: 25px;
            width: 25px;
            border-radius: 50%;
            padding: 5px;
            top: 1px;
        }

        &:not(.collapsed) {
            color: rgb(255, 253, 250);
            border-bottom: 1px solid rgb(255, 253, 250);

            img {
                transform: rotate(270deg);
            }
        }
    }

    .accordion-header{
        font-size: 15px;
        font-style: normal;
        font-weight: 700;
        line-height: 100%; /* 14px */
        color: rgba(255, 255, 255, 0.8);
        text-transform: Capitalize;
    }

    .accordion-body {
        ul {
            margin-top: 0;
            padding-bottom: 20px;
            padding-left: 0;
            height: max-content;

            li a {
                font-size: 15px;
                line-height: 24px;
                font-weight: 400;
                color: #fff !important;
            }
        }
    }
}`

export default MyMenu;
