"use client";
import React, {useEffect, useRef, useState} from "react";
import styled from "styled-components";
import gsap from "gsap";
import { ScrollTrigger } from "gsap/ScrollTrigger";
import blur from '@/public/images/static/blur.svg'
gsap.registerPlugin(ScrollTrigger);

const ImageReveal = ({
                         src,
                         alt,
                         objectFit,
                         position,
                         height,
                         width,
                         left,
                         margin,
                         right,
                         top,
                         bottom,
                         srcSm
                     }) => {


    const [deviceWidth, setDeviceWidth] = useState(0);

    // set device width
    useEffect(() => {
        function HandleWidth() {
            setDeviceWidth(window.innerWidth)
        }

        window.addEventListener('resize', HandleWidth)
        HandleWidth()
        return () => {
            window.removeEventListener('resize', HandleWidth)
        };
    });
    const containerRef = useRef(null);

    useEffect(() => {
        const container = containerRef.current;
        const image = container.querySelector("img");

        // Reveal Animation
        const revealTl = gsap.timeline({
            scrollTrigger: {
                trigger: container,
                toggleActions: "restart none none reset",
            },
        });

        revealTl.set(container, { autoAlpha: 1 });
        revealTl.from(container, {
            xPercent: -100,
            ease: "power4.inOut",
            duration: 1.5,
            marginLeft: -40,
        });
        revealTl.from(image, {
            xPercent: 100,
            ease: "power4.inOut",
            duration: 1.5,
            delay: -1.5,
            stagger: 0.15,
        });

        // Parallax Effect
        const parallaxTl = gsap.to(image, {
            yPercent: -15,
            ease: "none",
            scrollTrigger: {
                trigger: container,
                scrub: true,
            },
        });

        return () => {
            // Cleanup GSAP effects
            revealTl.kill();
            parallaxTl.kill();
            ScrollTrigger.getAll().forEach((trigger) => trigger.kill());
        };
    }, []);

    return (
        <StyledImg
            className="global-image reveal"
            ref={containerRef}
            objectFit={objectFit}
            margin={margin}
            position={position}
            left={left}
            right={right}
            top={top}
            bottom={bottom}
            height={height}
            width={width}
        >
            <Image
                blurDataURL="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQE..."
                placeholder={"blur"}
                alt={alt ? alt : src}
                objectFit={'cover'}
                layout={'fill'}
                src={src}  />
        </StyledImg>
    );
};

const StyledImg = styled.div`
  position: ${(props) => props.position || "absolute"};
  height: ${(props) => props.height || "100%"};
  width: ${(props) => props.width || "100%"};
  top: ${(props) => props.top || 0};
  left: ${(props) => props.left || 0};
  bottom: ${(props) => props.bottom || 0};
  right: ${(props) => props.right || 0};
  margin: ${(props) => props.margin || 0};
  opacity: 0; /* Initially hidden */

  img {
    width: 100%;
    height: 100%;
    object-fit: ${(props) => props.objectFit || "cover"};
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
  }
`;

export default React.memo(ImageReveal);
