"use client";
import styled from "styled-components";
import React, { useEffect, useRef, useState } from "react";
import { Img } from "@/components/Img";
import {Col, Container, Row} from "react-bootstrap";
import { Swiper, SwiperSlide } from 'swiper/react';
import {Autoplay, Mousewheel, Navigation, Pagination} from "swiper";
import 'swiper/css';
import 'swiper/css/navigation';
import 'swiper/css/pagination';
import reactHtmlParser from "react-html-parser";
import HistoryCard from "@/components/HistoryCard";


const HistorySlider = ({bigtitle, pt, pb, data}) => {
    const containerRef = useRef();
    const sliderRef = useRef();
    const [offset, setOffset] = useState(90);
    const [progress, setProgress] = useState(0);
    const [activeTitle, setActiveTitle] = useState('');
    const [activeYear, setActiveYear] = useState('');
    const [shouldAnimate, setShouldAnimate] = useState(false);


    useEffect(() => {
        const updateOffset = () => {
            setOffset(document.querySelector('.container').offsetLeft);
        };

        window.addEventListener('load', updateOffset);
        window.addEventListener('resize', updateOffset);
        updateOffset();

        return () => {
            window.removeEventListener('load', updateOffset);
            window.removeEventListener('resize', updateOffset);
        };

    }, []);

    const updateProgressBar = (swiper) => {
        const totalSlides = swiper.slides.length;
        const activeIndex = swiper.realIndex;
        const newProgress = ((activeIndex + 1) / totalSlides) * 100;
        setProgress(newProgress);

        const activeSlide = data?.posts?.list[activeIndex];
        // Reset animation
        setShouldAnimate(false);


        // Update title with animation
        setTimeout(() => {
            setActiveTitle(activeSlide.data?.subtitle);
            setActiveYear(activeSlide.data?.short_desc);
            setShouldAnimate(true);
        }, 50);
    };


    return (
        <StyledComponent offset={offset}  className={`${pt ? pt : 'pt-120'} ${pb ? pb : 'pb-120'}`}>
            <Container>
                <div className="top">
                    <div className="top__left">
                        {
                            bigtitle ?
                            <h2 className={'big'}  data-speed={1.1}>{reactHtmlParser(data?.section_data?.subtitle)}</h2>
                                :
                                <h2 className={'small split-up'}>{reactHtmlParser(data?.section_data?.subtitle)}</h2>
                        }
                    </div>
                    <div className="top__right">
                        <ul>
                            <li className={'slider_prev'}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                     fill="none">
                                    <g clipPath="url(#clip0_4006_21)">
                                        <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                        <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_4006_21">
                                            <rect width="16.9706" height="16.9706" fill="white"
                                                  transform="translate(0.5 0.514648)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                            <li className={'slider_next'}>
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                     fill="none">
                                    <g clipPath="url(#clip0_4006_21)">
                                        <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                        <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                              strokeLinecap="round" strokeLinejoin="round"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_4006_21">
                                            <rect width="16.9706" height="16.9706" fill="white"
                                                  transform="translate(0.5 0.514648)"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </li>
                        </ul>
                    </div>
                </div>
                <h5 className={`active-title ${shouldAnimate ? 'animate' : ''}`}>{reactHtmlParser(activeTitle)}</h5>
                <div className="progress-bar-container">
                    <div className="progress-bar" style={{width: `${progress}%`}}></div>
                </div>
                <p className="active-year">{activeYear}</p>
            </Container>
            <Container fluid className="slider-container" ref={containerRef}>
                {
                    data?.posts &&
                    <Swiper
                        loop={true}
                        slidesPerView={'auto'}
                        spaceBetween={30}
                        speed={1000}
                        slidesPerGroup={1}
                        modules={[Autoplay, Pagination, Navigation, Mousewheel]}
                        navigation={{
                            prevEl: '.slider_prev',
                            nextEl: '.slider_next',
                        }}
                        effect="slide"
                        breakpoints={{
                            320: {
                                slidesPerView: 1,
                                spaceBetween: 30,
                            },
                            768: {
                                slidesPerView: 2,
                                spaceBetween: 30,
                            },
                            1024: {
                                slidesPerView: 3,
                                spaceBetween: 30,
                            },
                        }}
                        onSlideChange={(swiper) => updateProgressBar(swiper)}
                        onSwiper={(swiper) => {
                            updateProgressBar(swiper);
                        }}
                        ref={sliderRef}
                        className="mySwiper"
                    >
                        {
                            data?.posts?.list?.length > 0 &&
                            data?.posts?.list?.map((e,i)=>{
                                return(
                                    <SwiperSlide key={i}>
                                        <HistoryCard
                                            year={e?.data?.short_desc}
                                            img={e?.images?.[0]?.full_path}
                                            desc={e?.data?.description}
                                        />
                                    </SwiperSlide>
                                );
                            })
                        }
                    </Swiper>
                }
            </Container>
            <Container className={'mobile-nav'}>
                <div>
                    <ul>
                        <li className={'slider_prev'}>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                 fill="none">
                                <g clipPath="url(#clip0_4006_21)">
                                    <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                    <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_4006_21">
                                        <rect width="16.9706" height="16.9706" fill="white"
                                              transform="translate(0.5 0.514648)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </li>
                        <li className={'slider_next'}>
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"
                                 fill="none">
                                <g clipPath="url(#clip0_4006_21)">
                                    <path d="M4.74268 13.2424L13.228 4.75715" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                    <path d="M13.228 13.2424V4.75715H4.74275" stroke="#fff" strokeWidth="1.5"
                                          strokeLinecap="round" strokeLinejoin="round"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_4006_21">
                                        <rect width="16.9706" height="16.9706" fill="white"
                                              transform="translate(0.5 0.514648)"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </li>
                    </ul>
                </div>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    position: relative;
    background-color: #ffffff;
    padding-top: ${props => props.pt ? props.pt + 'px' : '20px'};;

    .progress-bar-container {
        width: 100%;
        height: 2px;
        background-color: rgba(0, 22, 125, 0.1);
        position: relative;
    }

    .progress-bar {
        position: absolute;
        top: 0;
        left: 0;
        height: 100%;
        background-color: #00167D;
        transition: width 0.7s ease-in-out;
        overflow: visible;
        

        &:after {
            content: "";
            position: absolute;
            top: -1px;
            right: 0;
            width: 4px;
            height: 4px;
            background-color: #001A94;
            border-radius: 50%;
        }
    }

    h5 {
        color: #000000;
        font-size: 18px;
        font-style: normal;
        font-weight: 500;
        line-height: 26px; /* 100% */
        margin-bottom: 30px;
    }

    .active-title {
        opacity: 0;
        transform: translateY(20px);
        transition: none;

        &.animate {
            transform: translateY(0);
            opacity: 1;
            transition: transform 0.7s ease-in-out, opacity 1.5s ease-in-out;
        }
    }

    .active-year{
        margin-top: 10px;
    }
    
    p {
        color: #000;
        font-size: 14px;
        font-style: normal;
        font-weight: 400;
        line-height: 24px; /* 171.429% */
    }

    .top {
        display: flex;
        justify-content: space-between;
        margin-bottom: 40px;
        &__left {
            .big {
                color: rgba(0, 26, 148, 1);
                font-size: 180px;
                font-style: normal;
                font-weight: 700;
                line-height: 100%; /* 180px */
                margin-top: -145px;
                position: relative;
                z-index: 3;
                mix-blend-mode: multiply;
            }

            .small {
                color: #00167D;
                font-size: 60px;
                font-style: normal;
                font-weight: 700;
                line-height: 70px; /* 60px */
            }
        }

        &__right {
            ul {
                display: flex;
                gap: 20px;

                li {
                    position: relative;
                    overflow: hidden;
                    height: 50px;
                    width: 50px;
                    background-color: #001A94;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 50%;
                    cursor: pointer;

                    //&:after {
                    //    content: '';
                    //    position: absolute;
                    //    height: 0;
                    //    width: 0;
                    //    left: 0;
                    //    right: 0;
                    //    top: 0;
                    //    bottom: 0;
                    //    margin: auto;
                    //    background-color: #001A94;
                    //    transition: all .5s ease;
                    //    border-radius: 50%;
                    //}
                    
                    svg{
                        transition: transform 0.3s ease;
                    }

                    &:first-child {
                        svg {
                            transform: rotate(270deg);
                            transition: transform 0.3s ease;
                        }
                    }
                    
                    &:hover{
                        //&:after {
                        //    height: 100%;
                        //    width: 100%;
                        //}
                        svg{
                            position: relative;
                            z-index: 99999;
                            transform: rotate(45deg);
                            transition: transform 0.3s ease;
                        }

                        &:first-child {
                            svg {
                                transform: rotate(225deg);
                            }
                        }
                    }
                }
            }
        }
    }
    
    .slider-container{
        padding-top: 30px;
    }


    .swiper-initialized {
        margin-left: ${props => props.offset}px !important;
        margin-right: ${props => props.offset}px !important;
    }
    
    .swiper-slide-active{
        .slide-content{
            &__left{
                .year-label {
                    color: #001A94 !important;
                    text-align: right;
                    font-size: 100px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100%; /* 120px */
                    -webkit-text-stroke: unset !important;
                    transition: color 0.8s ease-in-out;
                }
            }
        }
    }
    
    .mobile-nav{
        opacity: 0;
        display: none;
    }

    
    @media(max-width: 767px){
        padding-top: 80px;
        .top{
            &__left{
                .big{
                    font-size: 60px !important;
                    font-style: normal !important;
                    font-weight: 700;
                    line-height: 100% !important; /* 60px */
                    margin-top: unset;
                }
                
            }
            &__right{
                opacity: 0;
            }
        }
        
        h5{
            color: #000000 !important;
            font-size: 18px;
            font-style: normal;
            font-weight: 500 !important;
            line-height: 26px !important; /* 120% */
            margin-bottom: 25px;
            br {
                display: none;
            }
        }
        
        p{
            font-size: 14px;
            font-style: normal;
            font-weight: 400;
            line-height: 20px; /* 142.857% */
        }
        
        
        .slider-container{
            padding-top: 30px;
        }
        .mobile-nav{
            opacity: 1;
            display: block;
            margin-top: 40px;
            ul {
                display: flex;
                gap: 20px;

                li {
                    position: relative;
                    overflow: hidden;
                    height: 50px;
                    width: 50px;
                    background-color: #001A94;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 50%;
                    cursor: pointer;

                    &:after {
                        content: '';
                        position: absolute;
                        height: 0;
                        width: 0;
                        left: 0;
                        right: 0;
                        top: 0;
                        bottom: 0;
                        margin: auto;
                        background-color: #001A94;
                        transition: all .5s ease;
                        border-radius: 50%;
                    }

                    &:first-child {
                        svg {
                            transform: rotate(270deg);
                        }
                    }

                    &:hover{
                        &:after {
                            height: 100%;
                            width: 100%;
                        }
                        svg{
                            position: relative;
                            z-index: 99999;
                        }
                    }
                }
            }
        }
    }

    @media(max-width: 991px){
        padding-top: 80px;
        .top{
            margin-bottom: 40px;
            &__left{
                .big{
                    font-size: 60px !important;
                    font-style: normal !important;
                    font-weight: 700;
                    line-height: 100% !important; /* 60px */
                    margin-top: unset;
                }
            }
            &__right{
                opacity: 0;
            }
        }

        h5{
            color: #001A94;
            font-size: 20px;
            font-style: normal;
            font-weight: 700;
            line-height: 24px; /* 120% */
            margin-bottom: 15px;
        }

        p{
            font-size: 14px;
            font-style: normal;
            font-weight: 400;
            line-height: 20px; /* 142.857% */
        }


        .slider-container{
            padding-top: 30px;
        }
        .mobile-nav{
            opacity: 1;
            display: block;
            margin-top: 40px;
            ul {
                display: flex;
                gap: 20px;

                li {
                    position: relative;
                    overflow: hidden;
                    height: 50px;
                    width: 50px;
                    background-color: #001A94;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 50%;
                    cursor: pointer;

                    &:after {
                        content: '';
                        position: absolute;
                        height: 0;
                        width: 0;
                        left: 0;
                        right: 0;
                        top: 0;
                        bottom: 0;
                        margin: auto;
                        background-color: #001A94;
                        transition: all .5s ease;
                        border-radius: 50%;
                    }

                    &:first-child {
                        svg {
                            transform: rotate(270deg);
                        }
                    }

                    &:hover{
                        &:after {
                            height: 100%;
                            width: 100%;
                        }
                        svg{
                            position: relative;
                            z-index: 99999;
                        }
                    }
                }
            }
        }
    }


    .swiper-slide {
        opacity: 0.7;
        transition: transform 0.8s ease-in-out, opacity 0.8s ease-in-out;
    }

    .swiper-slide-active {
        transform: scale(1.01); /* Slight scale effect for the active slide */
        opacity: 1;
    }
    //
    //.swiper-slide-prev, .swiper-slide-next {
    //    opacity: 0.7;
    //}


`;

export default HistorySlider;
