'use client';
import styled from "styled-components";
import Img from "@/components/Img";


const MyComponent = ({year, img, desc}) => {
    return (
        <StyledComponent>
            <div className={'slide-content'}>
                <div className={'slide-content__left'}>
                    <h2 className={'year-label'}>
                        {year}
                    </h2>
                </div>
                <div className="slide-content__right">
                    <div className="img">
                        <Img src={img}/>
                    </div>
                    <p>{desc}</p>
                </div>
            </div>
        </StyledComponent>
    );
};

const StyledComponent = styled.div`
    .slide-content {
        display: -webkit-box;
        display: -webkit-flex;
        display: -ms-flexbox;
        display: flex;
        -webkit-box-align: start;
        -webkit-align-items: flex-start;
        -ms-flex-align: start;
        align-items: flex-start;

        &__left {
            -webkit-box-flex: 0;
            -webkit-flex: 0 0 100px;
            -ms-flex: 0 0 100px;
            flex: 0 0 100px;
            width: 100px;

            .year-label {
                text-align: right;
                font-size: 100px;
                font-style: normal;
                font-weight: 700;
                line-height: 100%;
                color: transparent;
                -webkit-text-stroke: 1px rgba(0, 22, 125, 0.6);
                text-transform: uppercase;
                -webkit-writing-mode: vertical-rl;
                -ms-writing-mode: tb-rl;
                writing-mode: vertical-rl;
                text-orientation: mixed;
                -webkit-transform: rotate(-180deg);
                -ms-transform: rotate(-180deg);
                transform: rotate(-180deg);
                margin-left: 10px;
                transition: color 0.8s ease-in-out;
            }
        }

        &__right {
            -webkit-box-flex: 1;
            -webkit-flex: 1;
            -ms-flex: 1;
            flex: 1;
            min-width: 0; // This prevents flex items from overflowing

            .img {
                padding-top: calc(160 / 270 * 100%);
                position: relative;
                overflow: hidden;
            }

            p {
                color: #000;
                font-size: 14px;
                font-style: normal;
                font-weight: 400;
                line-height: 20px;
                padding-top: 20px;
            }
        }
    }

    @media(max-width: 991px) {
        .slide-content {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            flex-direction: row;
            -webkit-box-align: start;
            -webkit-align-items: flex-start;
            -ms-flex-align: start;
            align-items: flex-start;
            &__left {
                -webkit-flex: 0 0 100px;
                -ms-flex: 0 0 100px;
                flex: 0 0 100px;
                width: 100px;

                .year-label {
                    //font-size: 80px;
                }
            }
        }
    }

    @media(max-width: 767px) {
        .slide-content {
            -webkit-box-orient: vertical;
            -webkit-box-direction: normal;
            -webkit-flex-direction: row;
            -ms-flex-direction: row;
            flex-direction: row;

            &__left {
                -webkit-flex: unset;
                //-ms-flex: 0 0 60px;
                flex: unset !important;
                margin-right: 0;
                margin-bottom: 20px;

                .year-label {
                    //font-size: 50px;
                    //line-height: 50px;
                    -webkit-text-stroke: 1px rgba(0, 22, 125, 0.6);
                    text-transform: uppercase;
                    -webkit-writing-mode: vertical-rl;
                    -ms-writing-mode: tb-rl;
                    writing-mode: vertical-rl;
                    text-orientation: mixed;
                    -webkit-transform: rotate(-180deg);
                    -ms-transform: rotate(-180deg);
                    transform: rotate(-180deg);
                }
            }

            &__right {
                width: 100%;
            }
        }
    }
`;

export default MyComponent;