'use client';
import styled from "styled-components";
import {Container, Row, Col, Form} from "react-bootstrap";
import Link from 'next/link'
import React, {useState} from "react";
import {useForm} from "react-hook-form";
import {toast} from "react-toastify";
import Button from "@/components/Button";
import reactHtmlParser from "react-html-parser";
import axios from "axios";

const ContactForm = ({title}) => {

    const [isSubmit, setIsSubmitting] = useState(false);
    const {register, control, handleSubmit, formState: {errors, isSubmitSuccessful, isSubmitting}, reset} = useForm({
        mode: "all",
    })


    //--- form submit
    const success = (msg) =>
        toast.success(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const error = (msg) =>
        toast.error(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const onSubmit = async (data) => {
        setIsSubmitting(true);
        try {
            const formData = new FormData();
            formData.append('name', data?.title);
            formData.append('email', data?.email);
            formData.append('phone', data?.phone);
            formData.append('message', data?.message);
            formData.append('form_id', 'contact-us-form');

            const response = await axios.post('https://project.bestinbd.com/projects/web/2404BGI/api/post-req-data/form-submit', formData);

            if (response.status === 200) {
                success('Form submitted successfully');
                reset(); // Reset form fields
            } else {
                error('Failed to submit form. Please try again later.');
            }
        } catch (err) {
            error('Failed to submit form. Please try again later.');
        } finally {
            setIsSubmitting(false)
        }
    };

    return (
        <StyledComponent className={'pt-120 pb-120'}>
            <Container>
                <Row>
                    <Col md={5} className={'content'}>
                        <h2 className={'split-up'}>{title ? reactHtmlParser(title) : "Any query? Let us know."}</h2>
                    </Col>
                    <Col md={{span: 6, offset: 1}}>
                        <Form>
                            <Form.Group className={'form-group'}>
                                <Form.Control {...register("title", {
                                    required: {
                                        value: true,
                                        message: "Please enter Name"
                                    },
                                })}
                                              type="text"
                                              placeholder="Full Name *"
                                              onFocus={(e) => (e.target.placeholder = "")}
                                              onBlur={(e) => (e.target.placeholder = "Full Name *")}
                                />
                                <p className={'form-error'}>{errors.title?.message}</p>
                            </Form.Group>

                            <div className="form-flex">
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Control {...register("email", {
                                            required: 'Please enter your email',
                                            pattern: {
                                                value: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i,
                                                message: 'Please enter a valid email address',
                                            },
                                        })}
                                                      type="email"
                                                      placeholder="Email *"
                                                      onFocus={(e) => (e.target.placeholder = "")}
                                                      onBlur={(e) => (e.target.placeholder = "Email *")}
                                        />
                                        <p className={'form-error'}>{errors.email?.message}</p>
                                    </Form.Group>
                                </div>
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Control {...register("phone", {
                                            required: 'Please enter your phone number',
                                            pattern: {
                                                value: /^01[0-9]{9}$/,
                                                message: 'Please enter a valid 11 digit phone number',
                                            },
                                        })}
                                                      type="number"
                                                      placeholder="Phone Number *"
                                                      onFocus={(e) => (e.target.placeholder = "")}
                                                      onBlur={(e) => (e.target.placeholder = "Phone Number *")}
                                        />
                                        <p className={'form-error'}>{errors.phone?.message}</p>
                                    </Form.Group>
                                </div>
                            </div>

                            <Form.Group className={'form-group'}>
                                <textarea  {...register('message', {
                                    required: {
                                        value: true,
                                        message: "Please enter a valid message"
                                    },
                                })}
                                           type="text"
                                           placeholder="Message *"
                                           onFocus={(e) => (e.target.placeholder = "")}
                                           onBlur={(e) => (e.target.placeholder = "Message *")}
                                />
                                <p className={'form-error'}>{errors.message?.message}</p>
                            </Form.Group>
                            <div className="form-btn" onClick={handleSubmit(onSubmit)}>
                                <Button text={'Submit Message'}/>
                            </div>
                        </Form>
                    </Col>
                </Row>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #25292C;
    h2{
        color: #ffffff;
    }



    .form-control {
        color: #ffffff !important;
    }
    
    .form-error{
        font-size: 12px;
        line-height: 16px;
        color: #EB1A1A;
    }
    
    .form-group{
        margin-bottom: 40px;
    }

    input {
        margin-bottom: 5px;
        border-bottom: 1px solid rgba(255 255 255 / 0.2) !important;
        font-size: 16px;
        line-height: 24px;
        color: #FFFFFF;
        transition: all 0.1s ease-in-out;
        &:focus {
            color: #FFFFFF;
            border-bottom: 1px solid #FFFFFF !important;
            transition: all 0.1s ease-in-out;
            outline: none !important;
        }
    }

    input:-webkit-autofill,
    input:-webkit-autofill:hover,
    input:-webkit-autofill:focus,
    input:-webkit-autofill:active {
        color: #ffffff !important;
        -webkit-text-fill-color: #FFFFFF !important;
        -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
        -webkit-background-clip: text !important;
        background-clip: text !important;
        border: none;
    }

    textarea:-webkit-autofill,
    textarea:-webkit-autofill:hover,
    textarea:-webkit-autofill:focus,
    textarea:-webkit-autofill:active {
        color: #ffffff !important;
        -webkit-text-fill-color: #FFFFFF !important;
        -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
        -webkit-background-clip: text !important;
        background-clip: text !important;
        border: none;
    }
    

    textarea {
        color: #ffffff;
        min-height: 80px;
        width: 100%;
        border: none !important;
        border-bottom: 1px solid rgba(255 255 255 / 0.2) !important;
        background-color: transparent;

        &:focus {
            color: #ffffff;
            border-bottom: 1px solid #ffffff !important;
            transition: all 0.1s ease-in-out;
            outline: none !important;
        }
    }
    
    @media(max-width: 767px){
        .content{
            margin-bottom: 75px;
        }
    }
`;

export default ContactForm;
