'use client';
import styled from "styled-components";
import {Container, Row, Col, Form} from "react-bootstrap";
import Link from 'next/link'
import Button from "@/components/Button";
import {useState} from "react";
import {useForm} from "react-hook-form";
import {toast} from "react-toastify";
import axios from "axios";
import reactHtmlParser from "react-html-parser";
import {useGoogleReCaptcha} from "react-google-recaptcha-v3";

const MyComponent = ({data}) => {
    const { executeRecaptcha } = useGoogleReCaptcha();
    const [isSubmit, setIsSubmitting] = useState(false);
    const {register, control, handleSubmit, formState: {errors, isSubmitSuccessful, isSubmitting}, reset} = useForm({
        mode: "all",
    })


    //--- form submit
    const success = (msg) =>
        toast.success(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const error = (msg) =>
        toast.error(msg, {
            position: "top-right",
            autoClose: 4000,
            closeOnClick: true,
            progress: undefined,
        });

    const onSubmit = async (data) => {
        setIsSubmitting(true);
        try {
            const token = await executeRecaptcha('submit');
            const formData = new FormData();
            formData.append('first_name', data?.first_name);
            formData.append('last_name', data?.last_name);
            formData.append('email', data?.email);
            formData.append('phone', data?.phone);
            formData.append('message', data?.message);
            formData.append('recaptcha_token', token);
            formData.append('form_id', 'contact-form');

            const response = await axios.post('https://project.bestinbd.com/2407NGI/api/post-req-data/form-submit', formData);

            if (response.status === 200) {
                success('Form submitted successfully');
                reset(); // Reset form fields
            } else {
                error('Failed to submit form. Please try again later.');
            }
        } catch (err) {
            error('Failed to submit form. Please try again later.');
        } finally {
            setIsSubmitting(false)
        }
    };

    return (
        <StyledComponent className={'pt-100 pb-100'}>
            <Container>
                <Row>
                    <Col md={3} className={'contact__left'}>
                        <div className={'contact__left__wrapper'}>
                            <h2 className={'split-up'}>{reactHtmlParser(data?.section_data?.subtitle)}</h2>
                            <p>
                                {reactHtmlParser(data?.section_data?.short_desc)}
                            </p>
                        </div>
                    </Col>
                    <Col md={{offset:1, span:8}} className={'contact__right'}>
                        <Form>
                            <div className="form-flex">
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="firstname">First Name*</Form.Label>
                                        <Form.Control
                                            {...register("first_name", {
                                                required: {
                                                    value: true,
                                                    message: "Please enter first name"
                                                },
                                            })}
                                            type="text"
                                            placeholder="John"
                                            onFocus={(e) => (e.target.placeholder = "")}
                                            onBlur={(e) => (e.target.placeholder = "John")}
                                            disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.first_name?.message}</p>
                                    </Form.Group>
                                </div>
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="secondname">Last Name *</Form.Label>
                                        <Form.Control
                                            {...register("last_name", {
                                                required: {
                                                    value: true,
                                                    message: "Please enter last name"
                                                },
                                            })}
                                            type="text"
                                            placeholder="Doe"
                                            onFocus={(e) => (e.target.placeholder = "")}
                                            onBlur={(e) => (e.target.placeholder = "Doe")}
                                            disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.last_name?.message}</p>
                                    </Form.Group>
                                </div>
                            </div>

                            <div className="form-flex">
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="email">Email *</Form.Label>
                                        <Form.Control {...register("email", {
                                            required: 'Please enter your email',
                                            pattern: {
                                                value: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i,
                                                message: 'Please enter a valid email address',
                                            },
                                        })}
                                                      type="email"
                                                      placeholder="your@gmail.com"
                                                      onFocus={(e) => (e.target.placeholder = "")}
                                                      onBlur={(e) => (e.target.placeholder = "your@gmail.com")}
                                                      disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.email?.message}</p>
                                    </Form.Group>
                                </div>
                                <div className="single">
                                    <Form.Group className={'form-group'}>
                                        <Form.Label htmlFor="phone">Phone Number *</Form.Label>
                                        <Form.Control {...register("phone", {
                                            required: 'Please enter your phone number',
                                            pattern: {
                                                value: /^01[0-9]{9}$/,
                                                message: 'Please enter a valid 11 digit phone number',
                                            },
                                        })}
                                                      type="number"
                                                      placeholder="01........."
                                                      onFocus={(e) => (e.target.placeholder = "")}
                                                      onBlur={(e) => (e.target.placeholder = "01.........")}
                                                      disabled={isSubmitting}  // Disable the field
                                        />
                                        <p className={'form-error'}>{errors.phone?.message}</p>
                                    </Form.Group>
                                </div>
                            </div>

                            <Form.Group className={'form-group'}>
                                <Form.Label htmlFor="message">Message *</Form.Label>
                                <textarea  {...register('message', {
                                    required: {
                                        value: true,
                                        message: "Please enter a valid message"
                                    },
                                })}
                                           type="text"
                                           placeholder="My message is"
                                           onFocus={(e) => (e.target.placeholder = "")}
                                           onBlur={(e) => (e.target.placeholder = "My message is")}
                                           disabled={isSubmitting}  // Disable the field
                                />
                                <p className={'form-error'}>{errors.message?.message}</p>
                            </Form.Group>
                            <div className="form-btn" onClick={handleSubmit(onSubmit)}>
                                <Button text={'Submit Message'} background={'#001A94'} color={'#FFF'}/>
                            </div>
                        </Form>
                    </Col>
                </Row>
            </Container>
        </StyledComponent>
    );
};

const StyledComponent = styled.section`
    background-color: #FFFFFF;
    
    .contact{
        &__left{
            h2{
                color: #00167D;
                font-size: 60px;
                font-style: normal;
                font-weight: 700;
                line-height: 100%; /* 60px */
                margin-bottom: 40px;
            }
            p{
                color: #000;
                font-size: 16px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 150% */
            }
        }
        &__right{

            .form-error{
                font-size: 12px;
                line-height: 16px;
                color: #EB1A1A;
            }

            .form-group{
                margin-bottom: 36px;
            }

            .form-flex{
                display: flex;
                gap: 30px;
                .single{
                    width: 50%;
                }
            }
            .form-label{
                margin-bottom: 0 !important;
                color: #001a95;
                font-size: 12px;
                font-style: normal;
                font-weight: 400;
                line-height: 20px; /* 166.667% */
            }
            input {
                border-bottom: 1px solid #001a95 !important;
                color: #000 !important;
                font-size: 20px;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 120% */
                transition: all 0.1s ease-in-out;
                &::placeholder{
                    color: #000 !important;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 120% */
                    opacity: 0.15;
                }
                &:focus {
                    color: #000 !important;
                    border-bottom: 1px solid #001A94 !important;
                    transition: all 0.1s ease-in-out;
                    outline: none !important;
                }

                &:disabled {
                    background-color: transparent;
                    cursor: not-allowed;
                }
            }

            input:-webkit-autofill,
            input:-webkit-autofill:hover,
            input:-webkit-autofill:focus,
            input:-webkit-autofill:active {
                color: #000000 !important;
                -webkit-text-fill-color: #000000 !important;
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                -webkit-background-clip: text !important;
                background-clip: text !important;
                border: none;
            }

            textarea:-webkit-autofill,
            textarea:-webkit-autofill:hover,
            textarea:-webkit-autofill:focus,
            textarea:-webkit-autofill:active {
                color: #000000 !important;
                -webkit-text-fill-color: #000000 !important;
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                -webkit-background-clip: text !important;
                background-clip: text !important;
                border: none;
            }


            textarea {
                min-height: 250px;
                width: 100%;
                border: none !important;
                border-bottom: 1px solid #001a95 !important;
                background-color: transparent;
                margin-top: 10px !important;
                margin-bottom: 5px;
                color: #000 !important;
                font-size: 20px !important;
                font-style: normal;
                font-weight: 400;
                line-height: 24px; /* 120% */
                transition: all 0.1s ease-in-out;
                border-radius: 0 !important;
                &::placeholder{
                    color: #000 !important;
                    font-size: 20px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 120% */
                    opacity: 0.15;
                }

                &:focus {
                    color: #000 !important;
                    border-bottom: 1px solid #001A94 !important;
                    transition: all 0.1s ease-in-out;
                    outline: none !important;
                }

                &:disabled {
                    background-color: transparent;  // Same styling as input
                    cursor: not-allowed;
                }
            }
        }
        
        @media(max-width: 767px){
            &__left{
                margin-bottom: 40px;
                h2{
                    color: #00167D;
                    font-size: 36px;
                    font-style: normal;
                    font-weight: 700;
                    line-height: 100%; /* 36px */
                    margin-bottom: 30px;
                }
                p{
                    color: #000;
                    font-size: 16px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 24px; /* 150% */
                }
            }
            
            &__right{
                .form-flex{
                    flex-direction: column;
                    gap: 0;
                    .single{
                        width: 100%;
                    }
                }
                
                .form-group{
                    margin-bottom: 20px;
                }
                
                .form-label{
                    color: #001a95;
                    font-size: 12px;
                    font-style: normal;
                    font-weight: 400;
                    line-height: 20px; /* 166.667% */
                }
                
                input{
                    &::placeholder{
                        color: #000;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }
                
                textarea{
                    min-height: 170px;
                    &::placeholder{
                        color: #000;
                        font-size: 18px;
                        font-style: normal;
                        font-weight: 400;
                        line-height: 24px; /* 133.333% */
                    }
                }
            }
        }
    }
    
    
    .form-btn{
        width: max-content;
        .dc-btn{
            width: max-content !important;
        }
    }
    
    @media(max-width: 991px){
        .contact__left{
            max-width: 100% !important;
            flex: 0 0 100% !important;
            margin-bottom: 40px;
        }
        
        .contact__right{
            max-width: 100% !important;
            flex: 0 0 100% !important;
            margin-left: 0 !important;
        }
    }
    
`;

export default MyComponent;
