"use client";
import React from "react";
import styled from 'styled-components';
import Link from "next/link";
import {title} from "@/styles/globalStyleVars";


const Button = ({
                    onSubmit,
                    text,
                    src,
                    img,
                    hoverImg,
                    fontSize,
                    fontWeight,
                    color,
                    letterSpacing,
                    lineHeight,
                    margin,
                    background,
                    borderRadius,
                    border,
                    width,
                    height,
                    hoverBackground,
                    target,
                    borderColor,
                    hoverColor,
                    svgColor
                }) => {


    return (
        <StyledBtn className={`dc-btn`}
                   fontSize={fontSize}
                   fontWeight={fontWeight}
                   color={color}
                   background={background}
                   lineHeight={lineHeight}
                   letterSpacing={letterSpacing}
                   margin={margin}
                   border={border}
                   img={img}
                   borderRadius={borderRadius}
                   width={width}
                   hoverImg={hoverImg}
                   hoverBackground={hoverBackground}
                   height={height}
                   borderColor={borderColor}
                   target={target}
                   hoverColor={hoverColor}
                   onSubmit={onSubmit}
        >
            {src ? (
                <Link href={src || '/'}>
                    <span> {text}  </span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                        <g clipPath="url(#clip0_4006_21)">
                            <path d="M4.74268 13.2424L13.228 4.75715" stroke={color} strokeWidth="1.5"
                                  strokeLinecap="round" strokeLinejoin="round"/>
                            <path d="M13.228 13.2424V4.75715H4.74275" stroke={color} strokeWidth="1.5"
                                  strokeLinecap="round" strokeLinejoin="round"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_4006_21">
                                <rect width="16.9706" height="16.9706" fill="white"
                                      transform="translate(0.5 0.514648)"/>
                            </clipPath>
                        </defs>
                    </svg>

                </Link>
            ) : (
                <a target={target || '_self'}>
                    <span>{text}</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                        <g clipPath="url(#clip0_4006_21)">
                            <path d="M4.74268 13.2424L13.228 4.75715" stroke={color} strokeWidth="1.5"
                                  strokeLinecap="round" strokeLinejoin="round"/>
                            <path d="M13.228 13.2424V4.75715H4.74275" stroke={color} strokeWidth="1.5"
                                  strokeLinecap="round" strokeLinejoin="round"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_4006_21">
                                <rect width="16.9706" height="16.9706" fill="white"
                                      transform="translate(0.5 0.514648)"/>
                            </clipPath>
                        </defs>
                    </svg>

                </a>
            )}
        </StyledBtn>
    )
};

const StyledBtn = styled.div`
    &.dc-btn {
        margin: ${props => props.margin || '0'};
        width: ${props => props.width || 'max-content'};
        height: ${props => props.height || '44'}px;
        cursor: pointer;

        a {
            display: flex;
            width: fit-content;
            height: 100%;
            align-items: center;
            justify-content: center;
            font-family: ${title};
            font-size: ${props => props.fontSize || '16'}px;
            font-weight: ${props => props.fontWeight || 400};
            margin: 0;
            line-height: ${props => props.lineHeight || '24'}px;
            letter-spacing: -0.48px;
            background-color: ${props => props.background || `#ffffff`};
            position: relative;
                //border-radius: ${props => props.borderRadius || '24'}px;
            overflow: hidden;
              z-index: 0;
              padding: 8px 16px;
              box-sizing: border-box;
              gap: 10px;
              svg{
                transition: 0.3s all ease-in-out;
              }
        
              span {
                transition: color .3s ease;
                color: ${props => props.color || `#001A94`};
                position: relative;
                z-index: 2;
              }
              
        
              &:hover {
                transition: 0.75s all ease-in-out;
                span {
                  color: ${props => props.hoverColor || ``};
                }
        
                svg{
                  transform: rotate(45deg);
                  transition: 0.3s all ease-in-out;
                }
              }
        
              &:focus {
                color: #222222;
              }
    }
  }

`;


export default Button;
