import Banner from "@/components/home/Banner";
import HistorySlider from "@/components/HistorySlider";
import Overview from "@/components/Overview";
import Video from "@/components/Video";
import Gallery from "@/components/home/Gallery";
import NewsSlider from "@/components/home/NewsSlider";
import GoogleMapsMarkers from "@/components/GoogleMapsMarkers";
import Contact from "@/components/Contact";
import {getApi} from "@/api/api";
import GalleryV2 from "@/components/home/GalleryV2";
import Visionaries from "@/components/about/Visionaries";
import reactHtmlParser from "react-html-parser";

export async function metadata() {
    const apiValue = "home";
    const getHomeData = await getApi(apiValue)
    const banner = getHomeData?.data?.sections?.find(
        (f) => f?.section_data?.template === "banner"
    );
    return {
        title: {
            default: `${reactHtmlParser(getHomeData?.data?.page_data?.meta_title)} | Nasir Group of Industries`,
        },
        description: `${getHomeData?.data?.page_data?.meta_description}`,
        openGraph: {
            title: `${getHomeData?.data?.page_data?.og_title}`,
            description: `${getHomeData?.data?.page_data?.og_description}`,
            images: [
                {
                    url: `${banner?.images?.list?.filter(f=>f?.video != 'on')?.[0]?.full_path}`,
                    alt: `${getHomeData?.data?.page_data?.meta_title}`,
                },
            ],
        },
    };
}
export default async function Home() {

    const apiValue = "home";
    const getHomeData = await getApi(apiValue)

    //Refactor
    const banner = getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "banner");
    const overview = getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "overview");
    const counter =  getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "counter");
    const video =  getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "video");
    const history =  getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "history");
    const gallery =  getHomeData?.concerns?.list;
    const news =  getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "news");
    const newslist =  getHomeData?.news;
    const map =  getHomeData?.concerns?.list;
    const contact =  getHomeData?.data?.sections?.find((f) => f?.section_data?.template === "contact");

    return (
        <>
            <Banner data={banner}/>
            <Overview src pt={'pt-200'} pb={'pb-120'} data={overview} counter={counter}/>
            <Visionaries
                title={video?.section_data?.subtitle}
                id={video?.section_data?.short_desc}
                img={video?.images?.list?.filter(f=>f?.background === 'on')?.[0]?.full_path}
            />

            {/*<Video img={video?.images?.list?.filter(f=>f?.background === 'on')?.[0]?.full_path} id={video?.section_data?.short_desc} title={video?.section_data?.subtitle}/>*/}
            <HistorySlider data={history} pt={'pt-200'} />
            <Gallery data={gallery}/>
            {/*<GalleryV2 data={gallery}/>*/}
            <NewsSlider data={news} list={newslist}/>
            <GoogleMapsMarkers data={map}/>
            <Contact data={contact}/>
        </>
    );
};


