import InnerBanner from "@/components/InnerBanner";
import NewsListings from "@/components/News/NewsListings";
import {getApi} from "@/api/api";
import reactHtmlParser from "react-html-parser";
import InnerBannerNew from "@/components/InnerBannerNew";

export async function metadata() {
    const apiValue = "news--media";
    const getData = await getApi(apiValue)
    const banner = getData?.data?.sections?.find(
        (f) => f?.section_data?.template === "banner"
    );
    return {
        title: {
            default: `${reactHtmlParser(getData?.data?.page_data?.meta_title)} | Nasir Group of Industries`,
        },
        description: `${getData?.data?.page_data?.meta_description}`,
        openGraph: {
            title: `${getData?.data?.page_data?.og_title}`,
            description: `${getData?.data?.page_data?.og_description}`,
            images: [
                {
                    url: `${banner?.images?.list?.filter(f=>f?.video != 'on')?.[0]?.full_path}`,
                    alt: `${getData?.data?.page_data?.meta_title}`,
                },
            ],
        },
    };
}

export default async function Home() {
    const apiValue = "news--media";
    const getData = await getApi(apiValue)

    //Refactor
    const banner = getData?.data?.sections?.find((f) => f?.section_data?.template === "banner");
    const news =  getData?.news;

    return (
        <>
            <InnerBanner
                data={banner}
            />
            <NewsListings data={news}/>
        </>
    );
};


