'use client'
import StyledComponentsRegistry from "@/lib/registry";
import 'bootstrap/dist/css/bootstrap.min.css';
import "react-toastify/dist/ReactToastify.css";
import {ToastContainer} from "react-toastify";
import GlobalStyle from "@/styles/globalStyle";
import "/app/global.css";
import {useEffect, useRef, useState} from "react";
import {usePathname} from "next/navigation";
import Footer from "@/components/Footer";
import {gsap} from "gsap";
import {ScrollTrigger} from "gsap/dist/ScrollTrigger";
import {ScrollSmoother} from "gsap/dist/ScrollSmoother";
import {ScrollToPlugin} from "gsap/dist/ScrollToPlugin";
import {Parallax, ParallaxX} from "@/components/animations/Parallax";
import {TextAnimation} from "@/components/animations/TextAnimation";
import PageTransition from "@/components/PageTransition";
import StickyMessage from "@/components/StickyMessage";
import MenuNew from "@/components/MenuNew";
import {ImageReveal} from "@/components/animations/ImageReveal";
import Head from "next/head";
import HasprCursor from 'haspr-cursor' // Import Wrapper
import 'haspr-cursor/dist/cursor.css'
import {GoogleReCaptchaProvider} from "react-google-recaptcha-v3";

export default function RootLayout({children}) {
    const location = usePathname();
    gsap.registerPlugin(ScrollTrigger, ScrollSmoother, ScrollToPlugin);
    const [bgColor, setBGColor] = useState('#ffffff');
    const [textColor, setTextColor] = useState('#ffffff');

    useEffect(() => {
        if (location.startsWith('/news-media/')) {
            setBGColor('#292929');
            setTextColor('#001A94');
        } else {
            setBGColor('transparent');
            setTextColor('#ffffff');
        }
    }, [location]);

    const wrapperRef = useRef();
    const contentRef = useRef();
    let smoother;

    useEffect(() => {
        if (typeof window !== 'undefined' && window.innerWidth > 767) {
            smoother = ScrollSmoother.create({
                wrapper: wrapperRef.current,
                content: contentRef.current,
                smooth: 2,
                effects: true,
                // smoothTouch: 0.1
            });
        }
        ScrollTrigger.refresh();
        return () => {
            if (smoother) smoother.kill();
        };
    }, [location]);

    useEffect(() => {
        if (window.location.hash) {
            gsap.to(window, {duration: .7, scrollTo: window.location.hash});
        }
    });

    useEffect(() => {
        gsap.to(window, {duration: 0, scrollTo: 0});
    }, [location]);




    Parallax();
    TextAnimation();
    ImageReveal();

    return (
        <html lang="en">
        <head>
            <link rel="apple-touch-icon" sizes="180x180" href="/images/static/apple-touch-icon.png"/>
            <link rel="icon" type="image/png" sizes="32x32" href="/images/static/favicon-32x32.png"/>
            <link rel="icon" type="image/png" sizes="16x16" href="/images/static/favicon-16x16.png"/>
            <meta content="#000000" name="theme-color"/>
            <title>Nasir Group of Insustries</title>
        </head>
        <body>
        <StyledComponentsRegistry>
            <GoogleReCaptchaProvider
                reCaptchaKey={process.env.NEXT_PUBLIC_RECAPTCHA_SITE_KEY}
                scriptProps={{
                    async: false,
                    defer: false,
                    appendTo: 'head',
                }}
            >
                <HasprCursor>
                    {
                        location === '/' &&
                        <PageTransition/>
                    }
                    <GlobalStyle/>
                    <ToastContainer/>
                    <StickyMessage/>
                    {/*<Menu bgColor={bgColor} textColor={textColor}/>*/}
                    <MenuNew textColor={textColor}/>
                    <div ref={wrapperRef} id="smooth-wrapper">
                        <div ref={contentRef} id="smooth-content">
                            {children}
                            <Footer/>
                        </div>
                    </div>
                </HasprCursor>
            </GoogleReCaptchaProvider>
        </StyledComponentsRegistry>
        </body>
        </html>
    );
}