import InnerBanner from "@/components/InnerBanner";
import ConcernListing from "@/components/ConcernListing";
import {getApi} from "@/api/api";
import InnerBannerNew from "@/components/InnerBannerNew";
import IndustryLists from "@/components/concerns/IndustryLists";
import reactHtmlParser from "react-html-parser";

export async function metadata() {
    const apiValue = "concerns";
    const getData = await getApi(apiValue)
    const banner = getData?.data?.sections?.find(
        (f) => f?.section_data?.template === "banner"
    );
    return {
        title: {
            default: `${reactHtmlParser(getData?.data?.page_data?.meta_title)} | Nasir Group of Industries`,
        },
        description: `${getData?.data?.page_data?.meta_description}`,
        openGraph: {
            title: `${getData?.data?.page_data?.og_title}`,
            description: `${getData?.data?.page_data?.og_description}`,
            images: [
                {
                    url: `${banner?.images?.list?.filter(f=>f?.video != 'on')?.[0]?.full_path}`,
                    alt: `${getData?.data?.page_data?.meta_title}`,
                },
            ],
        },
    };
}

export default async function Concerns() {
    const apiValue = "concerns";
    const getData = await getApi(apiValue)

    //Refactor
    const banner = getData?.data?.sections?.find((f) => f?.section_data?.template === "banner");
    const concerns =  getData?.concerns?.list;

    return (
        <>
            <InnerBanner
                data={banner}
            />
            {/*<ConcernListing data={concerns}/>*/}
            <IndustryLists data={concerns}/>
        </>
    );
};


